/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.multiblock.BlockMultiblockBase;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileMachineCasing;

public class BlockMachineCasing
extends BlockMultiblockBase {
    public static final String[] types = new String[]{"standard", "reinforced", "advanced"};
    public static final PropertyInteger METADATA = PropertyInteger.func_177719_a((String)"type", (int)0, (int)types.length);

    public BlockMachineCasing(Material material) {
        super(material);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149663_c("techreborn.machineCasing");
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)METADATA, (Comparable)Integer.valueOf(0)));
    }

    public static ItemStack getStackByName(String name, int count) {
        name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModBlocks.MACHINE_CASINGS, count, i);
        }
        throw new InvalidParameterException("The machine casing " + name + " could not be found.");
    }

    public static ItemStack getStackByName(String name) {
        return BlockMachineCasing.getStackByName(name, 1);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)METADATA, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)METADATA);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{METADATA});
    }

    public int getHeatFromState(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 0: {
                return 40;
            }
            case 1: {
                return 68;
            }
            case 2: {
                return 95;
            }
        }
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack(item, 1, meta));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileMachineCasing();
    }
}

