/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.cable;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.energy.CapabilityEnergy;
import techreborn.client.TechRebornCreativeTab;
import techreborn.parts.powerCables.EnumCableType;
import techreborn.tiles.cable.TileCable;

public class BlockCable
extends BlockContainer {
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final IProperty<EnumCableType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumCableType.class);

    public BlockCable() {
        super(Material.field_151576_e);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149663_c("techreborn.cable");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a(TYPE, (Comparable)((Object)EnumCableType.COPPER)));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(this.func_176223_P());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EAST, WEST, NORTH, SOUTH, UP, DOWN, TYPE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(placer.func_184586_b(hand).func_77952_i());
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumCableType cableType : EnumCableType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, cableType.ordinal()));
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumCableType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCableType.values()[meta]));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float minX = (Boolean)(state = state.func_185899_b(source, pos)).func_177229_b((IProperty)WEST) != false ? 0.0f : 0.3125f;
        float minY = (Boolean)state.func_177229_b((IProperty)DOWN) != false ? 0.0f : 0.3125f;
        float minZ = (Boolean)state.func_177229_b((IProperty)NORTH) != false ? 0.0f : 0.3125f;
        float maxX = (Boolean)state.func_177229_b((IProperty)EAST) != false ? 1.0f : 0.6875f;
        float maxY = (Boolean)state.func_177229_b((IProperty)UP) != false ? 1.0f : 0.6875f;
        float maxZ = (Boolean)state.func_177229_b((IProperty)SOUTH) != false ? 1.0f : 0.6875f;
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState actualState = state;
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tileEntity = this.getTileEntitySafely(worldIn, pos.func_177972_a(facing));
            if (tileEntity == null) continue;
            actualState = actualState.func_177226_a(this.getProperty(facing), (Comparable)Boolean.valueOf(tileEntity.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())));
        }
        return actualState;
    }

    public TileEntity getTileEntitySafely(IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess instanceof ChunkCache) {
            return ((ChunkCache)blockAccess).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return blockAccess.func_175625_s(pos);
    }

    public IProperty<Boolean> getProperty(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return EAST;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCable();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

