/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.storage;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Random;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.IRotationTexture;
import techreborn.Core;
import techreborn.client.TechRebornCreativeTab;

public abstract class BlockEnergyStorage
extends BaseTileBlock
implements IRotationTexture,
ITexturedBlock {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)Facings.ALL);
    protected final String prefix = "techreborn:blocks/machines/energy/";
    public String name;
    public int guiID;

    public BlockEnergyStorage(String name, int guiID) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149663_c("techreborn." + name.toLowerCase());
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.name = name;
        this.guiID = guiID;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            player.openGui((Object)Core.INSTANCE, this.guiID, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)Facings.ALL);
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        if (placer.field_70125_A < -50.0f) {
            facing = EnumFacing.DOWN;
        } else if (placer.field_70125_A > 50.0f) {
            facing = EnumFacing.UP;
        }
        this.setFacing(facing, worldIn, pos);
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        return facingInt;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = this.getSideFromint(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        if (i == 4) {
            return EnumFacing.UP;
        }
        if (i == 5) {
            return EnumFacing.DOWN;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        if (facing == EnumFacing.UP) {
            return 4;
        }
        if (facing == EnumFacing.DOWN) {
            return 5;
        }
        return 0;
    }

    public String getFrontOff() {
        return "techreborn:blocks/machines/energy/" + this.getSimpleName(this.name.toLowerCase()) + "_front";
    }

    public String getFrontOn() {
        return "techreborn:blocks/machines/energy/" + this.getSimpleName(this.name.toLowerCase()) + "_front";
    }

    public String getSide() {
        return "techreborn:blocks/machines/energy/" + this.getSimpleName(this.name.toLowerCase()) + "_side";
    }

    public String getTop() {
        return "techreborn:blocks/machines/energy/" + this.getSimpleName(this.name.toLowerCase()) + "_side";
    }

    public String getBottom() {
        return "techreborn:blocks/machines/energy/" + this.getSimpleName(this.name.toLowerCase()) + "_side";
    }

    public String getTextureNameFromState(IBlockState blockState, EnumFacing facing) {
        if (this instanceof IRotationTexture) {
            BlockEnergyStorage rotationTexture = this;
            if (this.getFacing(blockState) == facing) {
                return rotationTexture.getFrontOff();
            }
            if (facing == EnumFacing.UP) {
                return rotationTexture.getTop();
            }
            if (facing == EnumFacing.DOWN) {
                return rotationTexture.getBottom();
            }
            return rotationTexture.getSide();
        }
        return "techreborn:blocks/machine/machine_side";
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public int amountOfStates() {
        return 6;
    }

    public String getSimpleName(String fullName) {
        if (fullName.equalsIgnoreCase("Batbox")) {
            return "lv_storage";
        }
        if (fullName.equalsIgnoreCase("MFE")) {
            return "mv_storage";
        }
        if (fullName.equalsIgnoreCase("MFSU")) {
            return "hv_storage";
        }
        if (fullName.equalsIgnoreCase("AESU")) {
            return "ev_storage_adjust";
        }
        if (fullName.equalsIgnoreCase("IDSU")) {
            return "ev_storage_transmitter";
        }
        if (fullName.equalsIgnoreCase("LESU")) {
            return "ev_multi";
        }
        return fullName.toLowerCase();
    }

    public static enum Facings implements Predicate<EnumFacing>,
    Iterable<EnumFacing>
    {
        ALL;


        public EnumFacing[] facings() {
            return new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};
        }

        public EnumFacing random(Random rand) {
            EnumFacing[] aenumfacing = this.facings();
            return aenumfacing[rand.nextInt(aenumfacing.length)];
        }

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != null;
        }

        @Override
        public Iterator<EnumFacing> iterator() {
            return Iterators.forArray((Object[])this.facings());
        }
    }
}

