/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.industrialSawmill;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.compat.jei.BaseRecipeWrapper;

public class IndustrialSawmillRecipeWrapper
extends BaseRecipeWrapper<IndustrialSawmillRecipe> {
    public static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/industrial_sawmill.png");
    private final IDrawableAnimated progress;

    public IndustrialSawmillRecipeWrapper(@Nonnull IJeiHelpers jeiHelpers, @Nonnull IndustrialSawmillRecipe baseRecipe) {
        super(baseRecipe);
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IDrawableStatic progressStatic = guiHelper.createDrawable(texture, 176, 14, 20, 13);
        int ticksPerCycle = baseRecipe.tickTime();
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Override
    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(FluidStack.class, (Object)((IndustrialSawmillRecipe)this.baseRecipe).fluidStack);
        super.getIngredients(ingredients);
    }

    @Override
    @Nonnull
    public List<FluidStack> getFluidInputs() {
        if (((IndustrialSawmillRecipe)this.baseRecipe).fluidStack != null) {
            return Collections.singletonList(((IndustrialSawmillRecipe)this.baseRecipe).fluidStack);
        }
        return Collections.emptyList();
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        this.progress.draw(minecraft, 48, 23);
        if (minecraft.field_71466_p != null) {
            int x = 70;
            int y = 40;
            int lineHeight = minecraft.field_71466_p.field_78288_b;
            minecraft.field_71466_p.func_78276_b("Time: " + ((IndustrialSawmillRecipe)this.baseRecipe).tickTime / 20 + " s", x, y, 0x444444);
            minecraft.field_71466_p.func_78276_b("FE: " + ((IndustrialSawmillRecipe)this.baseRecipe).euPerTick + " FE/t", x, y += lineHeight, 0x444444);
        }
    }
}

