/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.recipes;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import reborncore.common.util.CraftingHelper;
import techreborn.blocks.BlockStorage;
import techreborn.blocks.BlockStorage2;
import techreborn.config.ConfigTechReborn;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.DynamicCell;
import techreborn.items.ItemDustsSmall;
import techreborn.items.ItemNuggets;

public class CraftingTableRecipes
extends RecipeMethods {
    public static void init() {
        CraftingTableRecipes.registerCompressionRecipes();
        CraftingTableRecipes.registerMixedMetalIngotRecipes();
        CraftingTableRecipes.registerShapeless(BlockStorage2.getStorageBlockByName("iridium_reinforced_stone", 1), CraftingTableRecipes.getStack(Blocks.field_150348_b), CraftingTableRecipes.getMaterialObject("iridium", RecipeMethods.Type.INGOT));
        CraftingTableRecipes.registerShapeless(BlockStorage2.getStorageBlockByName("iridium_reinforced_tungstensteel", 1), BlockStorage2.getStorageBlockByName("tungstensteel", 1), CraftingTableRecipes.getMaterialObject("iridium", RecipeMethods.Type.INGOT));
        CraftingTableRecipes.registerShapeless(BlockStorage2.getStorageBlockByName("iridium_reinforced_tungstensteel", 1), BlockStorage2.getStorageBlockByName("iridium_reinforced_stone", 1), CraftingTableRecipes.getMaterialObject("tungstensteel", RecipeMethods.Type.INGOT));
        CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getStack(ModBlocks.RUBBER_PLANKS, 4), CraftingTableRecipes.getStack(ModBlocks.RUBBER_LOG));
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getStack(ModItems.FREQUENCY_TRANSMITTER), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER), "circuitBasic");
        }
        CraftingTableRecipes.registerShaped(DynamicCell.getEmptyCell(16), " T ", "T T", " T ", Character.valueOf('T'), "ingotTin");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.REFINED_IRON_FENCE), "RRR", "RRR", Character.valueOf('R'), CraftingTableRecipes.getStack(IC2Duplicates.REFINED_IRON));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.STEEL_DRILL), " S ", "SCS", "SBS", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.DIAMOND_DRILL), " D ", "DCD", "TST", Character.valueOf('D'), "gemDiamond", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('S'), CraftingTableRecipes.getStack(ModItems.STEEL_DRILL, 1, Short.MAX_VALUE), Character.valueOf('T'), "ingotTitanium");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ADVANCED_DRILL), " I ", "NCN", "OAO", Character.valueOf('I'), "ingotIridium", Character.valueOf('N'), "nuggetIridium", Character.valueOf('A'), CraftingTableRecipes.getStack(ModItems.DIAMOND_DRILL, 1, Short.MAX_VALUE), Character.valueOf('C'), "circuitMaster", Character.valueOf('O'), CraftingTableRecipes.getMaterial("overclock", RecipeMethods.Type.UPGRADE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.STEEL_CHAINSAW), " SS", "SCS", "BS ", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.DIAMOND_CHAINSAW), " DD", "TCD", "ST ", Character.valueOf('D'), "gemDiamond", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('S'), CraftingTableRecipes.getStack(ModItems.STEEL_CHAINSAW, 1, Short.MAX_VALUE), Character.valueOf('T'), "ingotTitanium");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ADVANCED_CHAINSAW), " NI", "OCN", "DO ", Character.valueOf('I'), "ingotIridium", Character.valueOf('N'), "nuggetIridium", Character.valueOf('D'), CraftingTableRecipes.getStack(ModItems.DIAMOND_CHAINSAW, 1, Short.MAX_VALUE), Character.valueOf('C'), "circuitMaster", Character.valueOf('O'), CraftingTableRecipes.getMaterial("overclock", RecipeMethods.Type.UPGRADE));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.STEEL_JACKHAMMER), "SBS", "SCS", " S ", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "reBattery");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.DIAMOND_JACKHAMMER), "DSD", "TCT", " D ", Character.valueOf('D'), "gemDiamond", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('S'), CraftingTableRecipes.getStack(ModItems.STEEL_JACKHAMMER, 1, Short.MAX_VALUE), Character.valueOf('T'), "ingotTitanium");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ADVANCED_JACKHAMMER), "NDN", "OCO", " I ", Character.valueOf('I'), "ingotIridium", Character.valueOf('N'), "nuggetIridium", Character.valueOf('D'), CraftingTableRecipes.getStack(ModItems.DIAMOND_DRILL, 1, Short.MAX_VALUE), Character.valueOf('C'), "circuitMaster", Character.valueOf('O'), CraftingTableRecipes.getMaterial("overclock", RecipeMethods.Type.UPGRADE));
        if (ConfigTechReborn.enableGemArmorAndTools) {
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.RUBY_SWORD), CraftingTableRecipes.getStack(ModItems.RUBY_PICKAXE), CraftingTableRecipes.getStack(ModItems.RUBY_AXE), CraftingTableRecipes.getStack(ModItems.RUBY_HOE), CraftingTableRecipes.getStack(ModItems.RUBY_SPADE), CraftingTableRecipes.getStack(ModItems.RUBY_HELMET), CraftingTableRecipes.getStack(ModItems.RUBY_CHESTPLATE), CraftingTableRecipes.getStack(ModItems.RUBY_LEGGINGS), CraftingTableRecipes.getStack(ModItems.RUBY_BOOTS), "gemRuby");
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.SAPPHIRE_SWORD), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_PICKAXE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_AXE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_HOE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_SPADE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_HELMET), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_CHSTPLATE), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_LEGGINGS), CraftingTableRecipes.getStack(ModItems.SAPPHIRE_BOOTS), "gemSapphire");
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.PERIDOT_SWORD), CraftingTableRecipes.getStack(ModItems.PERIDOT_PICKAXE), CraftingTableRecipes.getStack(ModItems.PERIDOT_AXE), CraftingTableRecipes.getStack(ModItems.PERIDOT_HOE), CraftingTableRecipes.getStack(ModItems.PERIDOT_SAPPHIRE), CraftingTableRecipes.getStack(ModItems.PERIDOT_HELMET), CraftingTableRecipes.getStack(ModItems.PERIDOT_CHESTPLATE), CraftingTableRecipes.getStack(ModItems.PERIDOT_LEGGINGS), CraftingTableRecipes.getStack(ModItems.PERIDOT_BOOTS), "gemPeridot");
            CraftingTableRecipes.addToolAndArmourRecipes(CraftingTableRecipes.getStack(ModItems.BRONZE_SWORD), CraftingTableRecipes.getStack(ModItems.BRONZE_PICKAXE), CraftingTableRecipes.getStack(ModItems.BRONZE_AXE), CraftingTableRecipes.getStack(ModItems.BRONZE_HOE), CraftingTableRecipes.getStack(ModItems.BRONZE_SPADE), CraftingTableRecipes.getStack(ModItems.BRONZE_HELMET), CraftingTableRecipes.getStack(ModItems.BRONZE_CHESTPLATE), CraftingTableRecipes.getStack(ModItems.BRONZE_LEGGINGS), CraftingTableRecipes.getStack(ModItems.BRONZE_BOOTS), "ingotBronze");
        }
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("copper", 6, RecipeMethods.Type.CABLE), "CCC", Character.valueOf('C'), "ingotCopper");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tin", 9, RecipeMethods.Type.CABLE), "TTT", Character.valueOf('T'), "ingotTin");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("gold", 12, RecipeMethods.Type.CABLE), "GGG", Character.valueOf('G'), "ingotGold");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("hv", 12, RecipeMethods.Type.CABLE), "RRR", Character.valueOf('R'), "ingotRefinedIron");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedcopper", 6, RecipeMethods.Type.CABLE), "RRR", "CCC", "RRR", Character.valueOf('R'), "itemRubber", Character.valueOf('C'), "ingotCopper");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedcopper", 6, RecipeMethods.Type.CABLE), "RCR", "RCR", "RCR", Character.valueOf('R'), "itemRubber", Character.valueOf('C'), "ingotCopper");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("insulatedcopper", RecipeMethods.Type.CABLE), "itemRubber", CraftingTableRecipes.getMaterialObject("copper", RecipeMethods.Type.CABLE));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedgold", 4, RecipeMethods.Type.CABLE), "RRR", "RGR", "RRR", Character.valueOf('R'), "itemRubber", Character.valueOf('G'), "ingotGold");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("insulatedgold", RecipeMethods.Type.CABLE), "itemRubber", "itemRubber", CraftingTableRecipes.getMaterialObject("gold", RecipeMethods.Type.CABLE));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("insulatedhv", 4, RecipeMethods.Type.CABLE), "RRR", "RIR", "RRR", Character.valueOf('R'), "itemRubber", Character.valueOf('I'), "ingotRefinedIron");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("insulatedhv", RecipeMethods.Type.CABLE), "itemRubber", "itemRubber", CraftingTableRecipes.getMaterialObject("hv", RecipeMethods.Type.CABLE));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 4, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 4, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 3, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemRuby", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 3, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "dustRuby", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 6, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotSilver", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 6, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotSilver", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 8, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotElectrum", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "blockGlass");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("glassfiber", 8, RecipeMethods.Type.CABLE), "GGG", "RDR", "GGG", Character.valueOf('R'), "ingotElectrum", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "blockGlass");
        }
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("carbon_fiber", RecipeMethods.Type.PART), "dustCoal", "dustCoal", "dustCoal", "dustCoal");
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("carbon_fiber", RecipeMethods.Type.PART), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL), CraftingTableRecipes.getMaterialObject("carbon", RecipeMethods.Type.CELL));
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("carbon_mesh", RecipeMethods.Type.PART), CraftingTableRecipes.getMaterialObject("carbon_fiber", RecipeMethods.Type.PART), CraftingTableRecipes.getMaterialObject("carbon_fiber", RecipeMethods.Type.PART));
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("computer_monitor", RecipeMethods.Type.PART), "ADA", "DGD", "ADA", Character.valueOf('D'), "dye", Character.valueOf('A'), "ingotAluminum", Character.valueOf('G'), "paneGlass");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.REINFORCED_GLASS, 7), "GAG", "GGG", "GAG", Character.valueOf('A'), "plateAdvancedAlloy", Character.valueOf('G'), "blockGlass");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.REINFORCED_GLASS, 7), "GGG", "AGA", "GGG", Character.valueOf('A'), "plateAdvancedAlloy", Character.valueOf('G'), "blockGlass");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.WIND_MILL, 2), "IXI", "XGX", "IXI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.WATER_MILL), "SWS", "WGW", "SWS", Character.valueOf('S'), "stickWood", Character.valueOf('W'), "plankWood", Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR));
        if (!IC2Duplicates.deduplicate()) {
            // empty if block
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("standard", 4, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), CraftingTableRecipes.getStack(IC2Duplicates.REFINED_IRON), Character.valueOf('C'), "circuitBasic", Character.valueOf('A'), CraftingTableRecipes.getMaterialObject("machine", RecipeMethods.Type.MACHINE_FRAME));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("reinforced", 4, RecipeMethods.Type.MACHINE_CASING), "RRR", "CAC", "RRR", Character.valueOf('R'), "ingotSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('A'), CraftingTableRecipes.getMaterialObject("advanced_machine", RecipeMethods.Type.MACHINE_FRAME));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("dataOrb", RecipeMethods.Type.PART), "DDD", "DID", "DDD", Character.valueOf('D'), "circuitData", Character.valueOf('I'), "circuitElite");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("dataControlCircuit", 4, RecipeMethods.Type.PART), "CDC", "DID", "CDC", Character.valueOf('I'), CraftingTableRecipes.getMaterialObject("iridium", RecipeMethods.Type.PLATE), Character.valueOf('D'), "circuitData", Character.valueOf('C'), "circuitAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.THERMAL_GENERATOR), "III", "IRI", "CGC", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), ModBlocks.REINFORCED_GLASS, Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR), Character.valueOf('C'), "circuitBasic");
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.HVT), "XHX", "XMX", "XHX", Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.MVT), Character.valueOf('H'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_IHV));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.MVT), "XGX", "XMX", "XGX", Character.valueOf('M'), CraftingTableRecipes.getMaterialObject("machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_IGOLD));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.LVT), "PWP", "CCC", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('C'), "ingotCopper", Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.BAT_BOX), "WCW", "BBB", "WWW", Character.valueOf('W'), "plankWood", Character.valueOf('B'), CraftingTableRecipes.getStack(ModItems.RE_BATTERY), Character.valueOf('C'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.MFE), "GEG", "EME", "GEG", Character.valueOf('M'), CraftingTableRecipes.getMaterialObject("machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('E'), CraftingTableRecipes.getStack(ModItems.ENERGY_CRYSTAL), Character.valueOf('G'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_IGOLD));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.MFSU), "LAL", "LML", "LOL", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('L'), CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_CRYSTAL), Character.valueOf('M'), CraftingTableRecipes.getStack(IC2Duplicates.MFE), Character.valueOf('O'), CraftingTableRecipes.getMaterialObject("advanced_machine", RecipeMethods.Type.MACHINE_FRAME));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), "SXS", "SCS", "SMS", Character.valueOf('C'), "circuitBasic", Character.valueOf('M'), CraftingTableRecipes.getMaterialObject("machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('S'), Blocks.field_150348_b);
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.ELECTRICAL_FURNACE), "XCX", "RFR", "XXX", Character.valueOf('C'), "circuitBasic", Character.valueOf('F'), CraftingTableRecipes.getStack(IC2Duplicates.IRON_FURNACE), Character.valueOf('R'), "dustRedstone");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.RECYCLER), "XEX", "DCD", "GDG", Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('C'), CraftingTableRecipes.getStack(IC2Duplicates.COMPRESSOR), Character.valueOf('G'), Items.field_151114_aO, Character.valueOf('E'), "circuitBasic");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.IRON_FURNACE), "III", "IXI", "III", Character.valueOf('I'), "ingotIron");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.IRON_FURNACE), "XIX", "IXI", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('F'), Blocks.field_150460_al);
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("electronic_circuit", RecipeMethods.Type.PART), "WWW", "SRS", "WWW", Character.valueOf('R'), CraftingTableRecipes.getStack(IC2Duplicates.REFINED_IRON), Character.valueOf('S'), Items.field_151137_ax, Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("advanced_circuit", RecipeMethods.Type.PART), "RGR", "LCL", "RGR", Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "dustGlowstone", Character.valueOf('L'), "gemLapis", Character.valueOf('C'), "circuitBasic");
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), "TMT", "TCT", "XXX", Character.valueOf('T'), CraftingTableRecipes.getStack(ModItems.TREE_TAP, true), Character.valueOf('M'), CraftingTableRecipes.getMaterialObject("machine", RecipeMethods.Type.MACHINE_FRAME), Character.valueOf('C'), "circuitBasic");
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), "RER", "CEC", "RER", Character.valueOf('R'), "plateIron", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('C'), "circuitAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.WRENCH), "BAB", "NBN", " B ", Character.valueOf('B'), "ingotBronze", Character.valueOf('N'), "nuggetBronze");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.RE_BATTERY), "XWX", "TRT", "TRT", Character.valueOf('T'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('W'), CraftingTableRecipes.getStack(IC2Duplicates.CABLE_ICOPPER));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), "RCR", "AEA", "RCR", Character.valueOf('R'), CraftingTableRecipes.getStack(IC2Duplicates.REFINED_IRON), Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('A'), "machineBlockAdvanced", Character.valueOf('C'), "circuitAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), "RCR", "AEA", "RCR", Character.valueOf('R'), "ingotAluminum", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('A'), "machineBlockAdvanced", Character.valueOf('C'), "circuitAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), "RCR", "AEA", "RCR", Character.valueOf('R'), "ingotAluminium", Character.valueOf('E'), CraftingTableRecipes.getStack(IC2Duplicates.EXTRACTOR), Character.valueOf('A'), "machineBlockAdvanced", Character.valueOf('C'), "circuitAdvanced");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.ENERGY_CRYSTAL), "RRR", "RDR", "RRR", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(ModItems.LAPOTRONIC_CRYSTAL), "LCL", "LEL", "LCL", Character.valueOf('L'), "dyeBlue", Character.valueOf('E'), "energyCrystal", Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getStack(IC2Duplicates.GENERATOR), CraftingTableRecipes.getStack(ModItems.RE_BATTERY), CraftingTableRecipes.getMaterialObject("machine", RecipeMethods.Type.MACHINE_FRAME), Blocks.field_150460_al);
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("machine", RecipeMethods.Type.MACHINE_FRAME), "AAA", "AXA", "AAA", Character.valueOf('A'), CraftingTableRecipes.getStack(IC2Duplicates.REFINED_IRON));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("advanced_machine", RecipeMethods.Type.MACHINE_FRAME), "XCX", "AMA", "XCX", Character.valueOf('A'), "plateAdvancedAlloy", Character.valueOf('C'), "plateCarbon", Character.valueOf('M'), CraftingTableRecipes.getMaterialObject("machine", RecipeMethods.Type.MACHINE_FRAME));
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("data_storage_circuit", RecipeMethods.Type.PART), "EEE", "ECE", "EEE", Character.valueOf('E'), "gemEmerald", Character.valueOf('C'), "circuitBasic");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("diamond_saw_blade", 4, RecipeMethods.Type.PART), "DSD", "S S", "DSD", Character.valueOf('D'), "dustDiamond", Character.valueOf('S'), "ingotSteel");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("diamond_grinding_head", 2, RecipeMethods.Type.PART), "DSD", "SGS", "DSD", Character.valueOf('S'), "ingotSteel", Character.valueOf('D'), "dustDiamond", Character.valueOf('G'), "gemDiamond");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tungsten_grinding_head", 2, RecipeMethods.Type.PART), "TST", "SBS", "TST", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotTungsten", Character.valueOf('B'), "blockSteel");
        if (ConfigTechReborn.UUrecipesWood) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150364_r, 8), " U ", "   ", "   ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesStone) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150348_b, 16), "   ", " U ", "   ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesSnowBlock) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150433_aE, 16), "U U", "   ", "   ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesGrass) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack((Block)Blocks.field_150349_c, 16), "   ", "U  ", "U  ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesObsidian) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150343_Z, 12), "U U", "U U", "   ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesGlass) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150359_w, 32), " U ", "U U", " U ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesCocoa) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151100_aR, 32, 3), "UU ", "  U", "UU ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesGlowstoneBlock) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150426_aN, 8), " U ", "U U", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesCactus) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack((Block)Blocks.field_150434_aF, 48), " U ", "UUU", "U U", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesSugarCane) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151120_aE, 48), "U U", "U U", "U U", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesVine) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150395_bd, 24), "U  ", "U  ", "U  ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesSnowBall) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151126_ay, 16), "   ", "   ", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151119_aD, 48), "UU ", "U  ", "UU ", Character.valueOf('U'), ModItems.UU_MATTER);
        if (ConfigTechReborn.UUrecipeslilypad) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150392_bi, 64), "U U", " U ", " U ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesGunpowder) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151016_H, 15), "UUU", "U  ", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesBone) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151103_aS, 32), "U  ", "UU ", "U  ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesFeather) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151008_G, 32), " U ", " U ", "U U", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesInk) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151100_aR, 48), " UU", " UU", " U ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesEnderPearl) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151079_bi, 1), "UUU", "U U", " U ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesCoal) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151044_h, 5), "  U", "U  ", "  U", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesIronOre) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150366_p, 2), "U U", " U ", "U U", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesGoldOre) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150352_o, 2), " U ", "UUU", " U ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesRedStone) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151137_ax, 24), "   ", " U ", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesLapis) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151100_aR, 9, 4), " U ", " U ", " UU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesEmeraldOre) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Blocks.field_150412_bA, 1), "UU ", "U U", " UU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesEmerald) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151166_bC, 2), "UUU", "UUU", " U ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesDiamond) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151045_i, 1), "UUU", "UUU", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesTinDust) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tin", 10, RecipeMethods.Type.DUST), "   ", "U U", "  U", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesCopperDust) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("copper", 10, RecipeMethods.Type.DUST), "  U", "U U", "   ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesLeadDust) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("lead", 14, RecipeMethods.Type.DUST), "UUU", "UUU", "U  ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesPlatinumDust) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("platinum", RecipeMethods.Type.DUST), "  U", "UUU", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesTungstenDust) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("tungsten", RecipeMethods.Type.DUST), "U  ", "UUU", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesTitaniumDust) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("titanium", 2, RecipeMethods.Type.DUST), "UUU", " U ", " U ", Character.valueOf('U'), ModItems.UU_MATTER);
        }
        if (ConfigTechReborn.UUrecipesAluminumDust) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("aluminum", 16, RecipeMethods.Type.DUST), " U ", " U ", "UUU", Character.valueOf('U'), ModItems.UU_MATTER);
        }
    }

    static void registerCompressionRecipes() {
        for (String name : (String[])ArrayUtils.addAll((Object[])BlockStorage.types, (Object[])BlockStorage2.types)) {
            ItemStack item = ItemStack.field_190927_a;
            try {
                item = CraftingTableRecipes.getMaterial(name, 9, RecipeMethods.Type.INGOT);
            }
            catch (InvalidParameterException e) {
                try {
                    item = CraftingTableRecipes.getMaterial(name, 9, RecipeMethods.Type.GEM);
                }
                catch (InvalidParameterException e2) {
                    continue;
                }
            }
            if (item.func_190926_b()) continue;
            CraftingTableRecipes.registerShaped(BlockStorage.getStorageBlockByName(name), "III", "III", "III", Character.valueOf('I'), item);
            CraftingTableRecipes.registerShapeless(item, BlockStorage.getStorageBlockByName(name, 9));
        }
        for (String name : (String[])ArrayUtils.addAll((Object[])BlockStorage.types, (Object[])BlockStorage2.types)) {
            CraftingTableRecipes.registerShaped(BlockStorage.getStorageBlockByName(name), "AAA", "AAA", "AAA", Character.valueOf('A'), "ingot" + name.substring(0, 1).toUpperCase() + name.substring(1));
            CraftingTableRecipes.registerShaped(BlockStorage.getStorageBlockByName(name), "AAA", "AAA", "AAA", Character.valueOf('A'), "gem" + name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        for (String name : ItemDustsSmall.types) {
            if (name.equals("PLACEHOLDER_ITEM")) continue;
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(name, 4, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.DUST));
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(name, RecipeMethods.Type.DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST), CraftingTableRecipes.getMaterialObject(name, RecipeMethods.Type.SMALL_DUST));
        }
        for (String nuggets : ItemNuggets.types) {
            if (nuggets.equals("PLACEHOLDER_ITEM") || nuggets.equalsIgnoreCase("diamond")) continue;
            CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial(nuggets, 9, RecipeMethods.Type.NUGGET), CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "ingot_" + nuggets));
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial(nuggets, RecipeMethods.Type.INGOT), "NNN", "NNN", "NNN", Character.valueOf('N'), CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "nugget_" + nuggets));
        }
        CraftingTableRecipes.registerShapeless(CraftingTableRecipes.getMaterial("diamond", 9, RecipeMethods.Type.NUGGET), "gemDiamond");
        CraftingTableRecipes.registerShaped(CraftingTableRecipes.getStack(Items.field_151045_i), "NNN", "NNN", "NNN", Character.valueOf('N'), "nuggetDiamond");
    }

    static void registerMixedMetalIngotRecipes() {
        if (!IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerMixedMetal("ingotRefinedIron", "ingotBronze", "ingotTin", 2);
            CraftingTableRecipes.registerMixedMetal("ingotRefinedIron", "ingotBronze", "ingotZinc", 2);
            CraftingTableRecipes.registerMixedMetal("ingotNickel", "ingotBronze", "ingotTin", 3);
            CraftingTableRecipes.registerMixedMetal("ingotNickel", "ingotBronze", "ingotZinc", 3);
            CraftingTableRecipes.registerMixedMetal("ingotNickel", "ingotBronze", "ingotAluminum", 4);
            CraftingTableRecipes.registerMixedMetal("ingotInvar", "ingotBronze", "ingotTin", 4);
            CraftingTableRecipes.registerMixedMetal("ingotInvar", "ingotBronze", "ingotZinc", 4);
            CraftingTableRecipes.registerMixedMetal("ingotInvar", "ingotBronze", "ingotAluminum", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTitanium", "ingotBronze", "ingotTin", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTitanium", "ingotBronze", "ingotZinc", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTungsten", "ingotBronze", "ingotTin", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTungsten", "ingotBronze", "ingotZinc", 5);
            CraftingTableRecipes.registerMixedMetal("ingotTitanium", "ingotBronze", "ingotAluminum", 6);
            CraftingTableRecipes.registerMixedMetal("ingotTungsten", "ingotBronze", "ingotAluminum", 6);
            CraftingTableRecipes.registerMixedMetal("ingotTungstensteel", "ingotBronze", "ingotTin", 8);
            CraftingTableRecipes.registerMixedMetal("ingotTungstensteel", "ingotBronze", "ingotZinc", 8);
            CraftingTableRecipes.registerMixedMetal("ingotTungstensteel", "ingotBronze", "ingotAluminum", 9);
        }
    }

    static void registerMixedMetal(String top, String middle, String bottom, int amount) {
        if (top.equals("ingotRefinedIron") && IC2Duplicates.deduplicate()) {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("mixed_metal", amount, RecipeMethods.Type.INGOT), "TTT", "MMM", "BBB", Character.valueOf('T'), CraftingTableRecipes.getStack(IC2Duplicates.REFINED_IRON), Character.valueOf('M'), middle, Character.valueOf('B'), bottom);
        } else {
            CraftingTableRecipes.registerShaped(CraftingTableRecipes.getMaterial("mixed_metal", amount, RecipeMethods.Type.INGOT), "TTT", "MMM", "BBB", Character.valueOf('T'), top, Character.valueOf('M'), middle, Character.valueOf('B'), bottom);
        }
        if (middle.equals("ingotBronze")) {
            CraftingTableRecipes.registerMixedMetal(top, "ingotBrass", bottom, amount);
        }
        if (bottom.equals("ingotAluminum")) {
            CraftingTableRecipes.registerMixedMetal(top, middle, "ingotAluminium", amount);
        }
    }

    static void registerShaped(ItemStack output, Object ... inputs) {
        CraftingHelper.addShapedOreRecipe((ItemStack)output, (Object[])inputs);
    }

    static void registerShapeless(ItemStack output, Object ... inputs) {
        CraftingHelper.addShapelessOreRecipe((ItemStack)output, (Object[])inputs);
    }

    static void addToolAndArmourRecipes(ItemStack sword, ItemStack pickaxe, ItemStack axe, ItemStack hoe, ItemStack spade, ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots, String material) {
        CraftingTableRecipes.registerShaped(sword, "G", "G", "S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(pickaxe, "GGG", " S ", " S ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(axe, "GG", "GS", " S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(hoe, "GG", " S", " S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(spade, "G", "S", "S", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(helmet, "GGG", "G G", Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(chestplate, "G G", "GGG", "GGG", Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(leggings, "GGG", "G G", "G G", Character.valueOf('G'), material);
        CraftingTableRecipes.registerShaped(boots, "G G", "G G", Character.valueOf('G'), material);
    }
}

