/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import reborncore.api.tile.IUpgrade;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.IMachineSlotProvider;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.InventoryHelper;
import reborncore.common.util.ItemNBTHelper;
import techreborn.Core;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.client.gui.upgrades.GuiSideConfig;
import techreborn.init.ModItems;
import techreborn.items.ItemTRNoDestroy;

public class ItemUpgrades
extends ItemTRNoDestroy
implements IUpgrade {
    public static final String[] types = new String[]{"overclock", "transformer", "energy_storage", "range", "ejection", "injection"};

    public ItemUpgrades() {
        this.func_77655_b("techreborn.upgrade");
        this.func_77627_a(true);
        this.func_77637_a(TechRebornCreativeTabMisc.instance);
        this.func_77625_d(1);
    }

    public static ItemStack getUpgradeByName(String name, int count) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModItems.UPGRADES, count, i);
        }
        throw new InvalidParameterException("The upgrade " + name + " could not be found.");
    }

    public static ItemStack getUpgradeByName(String name) {
        return ItemUpgrades.getUpgradeByName(name, 1);
    }

    public String func_77667_c(ItemStack itemStack) {
        int meta = itemStack.func_77952_i();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.func_77658_a() + "." + types[meta];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, NonNullList list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack(item, 1, meta));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (stack.func_77952_i() == 4 || stack.func_77952_i() == 5) {
            tooltip.add("Facing: " + this.getFacing(stack).func_176610_l());
            String text = Core.proxy.getUpgradeConfigText();
            if (!text.isEmpty()) {
                tooltip.add(text);
            }
        }
    }

    public void process(@Nonnull TileLegacyMachineBase machineBase, @Nullable RecipeCrafter crafter, @Nonnull ItemStack stack) {
        EnumFacing dir;
        if (stack.func_77952_i() == 0) {
            if (crafter != null) {
                crafter.addSpeedMulti(0.25);
                crafter.addPowerMulti(0.5);
            }
        } else if (stack.func_77952_i() == 4) {
            dir = this.getFacing(stack);
            TileEntity tileEntity = machineBase.func_145831_w().func_175625_s(machineBase.func_174877_v().func_177972_a(dir));
            if (tileEntity instanceof IInventory) {
                if (crafter != null) {
                    int[] nArray = crafter.outputSlots;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int amount;
                        Integer outSlot = nArray[i];
                        ItemStack outputStack = crafter.inventory.func_70301_a(outSlot.intValue());
                        if (outputStack.func_190926_b() || (amount = InventoryHelper.testInventoryInsertion((IInventory)((IInventory)tileEntity), (ItemStack)outputStack, (EnumFacing)dir)) <= 0) continue;
                        InventoryHelper.insertItemIntoInventory((IInventory)((IInventory)tileEntity), (ItemStack)outputStack);
                        crafter.inventory.func_70298_a(outSlot.intValue(), amount);
                    }
                } else if (machineBase instanceof IMachineSlotProvider) {
                    IMachineSlotProvider slotProvider = (IMachineSlotProvider)machineBase;
                    int[] nArray = slotProvider.getOuputSlots();
                    int n = nArray.length;
                    for (int outSlot = 0; outSlot < n; ++outSlot) {
                        int amount;
                        Integer outSlot2 = nArray[outSlot];
                        ItemStack outputStack = slotProvider.getMachineInv().func_70301_a(outSlot2.intValue());
                        if (outputStack.func_190926_b() || (amount = InventoryHelper.testInventoryInsertion((IInventory)((IInventory)tileEntity), (ItemStack)outputStack, (EnumFacing)dir)) <= 0) continue;
                        InventoryHelper.insertItemIntoInventory((IInventory)((IInventory)tileEntity), (ItemStack)outputStack);
                        slotProvider.getMachineInv().func_70298_a(outSlot2.intValue(), amount);
                    }
                } else {
                    TileLegacyMachineBase inventory = machineBase;
                    for (int outSlot = 0; outSlot < inventory.func_70302_i_(); ++outSlot) {
                        int amount;
                        ItemStack outputStack = inventory.func_70301_a(outSlot);
                        if (outputStack.func_190926_b() || (amount = InventoryHelper.testInventoryInsertion((IInventory)((IInventory)tileEntity), (ItemStack)outputStack, (EnumFacing)dir)) <= 0) continue;
                        InventoryHelper.insertItemIntoInventory((IInventory)((IInventory)tileEntity), (ItemStack)outputStack);
                        inventory.func_70298_a(outSlot, amount);
                    }
                }
            }
        } else if (stack.func_77952_i() == 5) {
            if (machineBase.func_145831_w().func_82737_E() % 10L != 0L) {
                return;
            }
            dir = this.getFacing(stack);
            TileEntity tileEntity = machineBase.func_145831_w().func_175625_s(machineBase.func_174877_v().func_177972_a(dir));
            if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) {
                IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack extractedStack;
                    int amount;
                    ItemStack stack1 = itemHandler.getStackInSlot(i);
                    if (crafter != null && !crafter.isStackValidInput(stack1) || (amount = InventoryHelper.testInventoryInsertion((IInventory)machineBase, (ItemStack)(extractedStack = itemHandler.extractItem(i, 1, true)), null)) <= 0) continue;
                    extractedStack = itemHandler.extractItem(i, 1, false);
                    extractedStack.func_190920_e(1);
                    InventoryHelper.insertItemIntoInventory((IInventory)machineBase, (ItemStack)extractedStack);
                }
            }
        }
        if (machineBase instanceof TilePowerAcceptor) {
            TilePowerAcceptor acceptor;
            if (stack.func_77952_i() == 2) {
                acceptor = (TilePowerAcceptor)machineBase;
                acceptor.extraPowerStoage += 40000.0;
            }
            if (stack.func_77952_i() == 1) {
                acceptor = (TilePowerAcceptor)machineBase;
                ++acceptor.extraTeir;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleRightClick(TileEntity tile, ItemStack stack, Container container, int slotID) {
        if (tile.func_145831_w().field_72995_K && (stack.func_77952_i() == 4 || stack.func_77952_i() == 5)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSideConfig((EntityPlayer)Minecraft.func_71410_x().field_71439_g, tile, this.getContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g), slotID));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BuiltContainer getContainer(EntityPlayer player) {
        return new ContainerBuilder("sides").create();
    }

    public EnumFacing getFacing(ItemStack stack) {
        return EnumFacing.field_82609_l[ItemNBTHelper.getInt((ItemStack)stack, (String)"side", (int)0)];
    }
}

