/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.powerSystem.PoweredItem;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.tools.ItemDrill;

public class ItemAdvancedDrill
extends ItemDrill {
    public ItemAdvancedDrill() {
        super(Item.ToolMaterial.DIAMOND, "techreborn.advancedDrill", ConfigTechReborn.AdvancedDrillCharge, ConfigTechReborn.AdvancedDrillTier, 4.0f, 20.0f);
        this.cost = 250;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, NonNullList itemList) {
        ItemStack stack = new ItemStack(ModItems.ADVANCED_DRILL);
        ItemStack uncharged = stack.func_77946_l();
        ItemStack charged = stack.func_77946_l();
        PoweredItem.setEnergy((double)this.getMaxPower(charged), (ItemStack)charged);
        itemList.add((Object)uncharged);
        itemList.add((Object)charged);
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return Items.field_151046_w.func_150897_b(blockIn) || Items.field_151047_v.func_150897_b(blockIn);
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        block10: {
            EnumFacing enumfacing;
            block11: {
                block9: {
                    enumfacing = entityLiving.func_174811_aO().func_176734_d();
                    if (entityLiving.field_70125_A < -50.0f) {
                        enumfacing = EnumFacing.DOWN;
                    } else if (entityLiving.field_70125_A > 50.0f) {
                        enumfacing = EnumFacing.UP;
                    }
                    if (enumfacing != EnumFacing.SOUTH && enumfacing != EnumFacing.NORTH) break block9;
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            this.breakBlock(pos.func_177982_a(i, j, 0), stack, worldIn, entityLiving, pos);
                        }
                    }
                    break block10;
                }
                if (enumfacing != EnumFacing.EAST && enumfacing != EnumFacing.WEST) break block11;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        this.breakBlock(pos.func_177982_a(0, j, i), stack, worldIn, entityLiving, pos);
                    }
                }
                break block10;
            }
            if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) break block10;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    this.breakBlock(pos.func_177982_a(j, 0, i), stack, worldIn, entityLiving, pos);
                }
            }
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public void breakBlock(BlockPos pos, ItemStack stack, World world, EntityLivingBase entityLiving, BlockPos oldPos) {
        if (oldPos == pos) {
            return;
        }
        if (!PoweredItem.canUseEnergy((double)this.cost, (ItemStack)stack)) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        List stuff = block.getDrops((IBlockAccess)world, pos, blockState, 0);
        ArrayList dropList = new ArrayList();
        BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(world, pos, blockState, 0, 1.0f, dropList, (EntityPlayer)entityLiving, false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        for (ItemStack drop : dropList) {
            if (drop.func_190926_b() || drop.func_190916_E() <= 0) continue;
            stuff.add(drop);
        }
        for (ItemStack drop : stuff) {
            if (world.field_72995_K) continue;
            EntityItem entityitem = new EntityItem(world, (double)oldPos.func_177958_n(), (double)oldPos.func_177956_o(), (double)oldPos.func_177952_p(), drop);
            entityitem.field_70159_w = (float)(oldPos.func_177958_n() - oldPos.func_177958_n()) / 10.0f;
            entityitem.field_70181_x = 0.15f;
            entityitem.field_70179_y = (float)(oldPos.func_177952_p() - oldPos.func_177952_p()) / 10.0f;
            world.func_72838_d((Entity)entityitem);
        }
        PoweredItem.useEnergy((double)this.cost, (ItemStack)stack);
        world.func_175698_g(pos);
    }
}

