/*
 * Decompiled with CFR 0.152.
 */
package techreborn.parts.powerCables;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.common.RebornCoreConfig;
import reborncore.common.misc.Functions;
import reborncore.common.misc.vecmath.Vecs3dCube;
import reborncore.common.util.WorldUtils;
import reborncore.mcmultipart.MCMultiPartMod;
import reborncore.mcmultipart.microblock.IMicroblock;
import reborncore.mcmultipart.multipart.IMultipartContainer;
import reborncore.mcmultipart.multipart.INormallyOccludingPart;
import reborncore.mcmultipart.multipart.ISlottedPart;
import reborncore.mcmultipart.multipart.Multipart;
import reborncore.mcmultipart.multipart.MultipartHelper;
import reborncore.mcmultipart.multipart.OcclusionHelper;
import reborncore.mcmultipart.multipart.PartSlot;
import reborncore.mcmultipart.raytrace.PartMOP;
import techreborn.parts.TechRebornParts;
import techreborn.parts.powerCables.EnumCableType;
import techreborn.parts.powerCables.ICableType;
import techreborn.parts.walia.IPartWaliaProvider;

public abstract class CableMultipart
extends Multipart
implements INormallyOccludingPart,
ISlottedPart,
ITickable,
ICableType,
IPartWaliaProvider,
IEnergyStorage {
    public static final IUnlistedProperty<Boolean> UP = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"up"));
    public static final IUnlistedProperty<Boolean> DOWN = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"down"));
    public static final IUnlistedProperty<Boolean> NORTH = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"north"));
    public static final IUnlistedProperty<Boolean> EAST = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"east"));
    public static final IUnlistedProperty<Boolean> SOUTH = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"south"));
    public static final IUnlistedProperty<Boolean> WEST = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"west"));
    public static final IProperty<EnumCableType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumCableType.class);
    public Vecs3dCube[] boundingBoxes = new Vecs3dCube[14];
    public float center = 0.6f;
    public float offset = 0.1f;
    public Map<EnumFacing, BlockPos> connectedSides = new HashMap<EnumFacing, BlockPos>();
    public int ticks = 0;
    public ItemStack stack;
    public int power = 0;

    public CableMultipart() {
        this.refreshBounding();
    }

    public static CableMultipart getPartFromWorld(World world, BlockPos pos, EnumFacing side) {
        ISlottedPart slottedPart;
        if (world == null || pos == null) {
            return null;
        }
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (side != null && container != null && (slottedPart = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)side))) instanceof IMicroblock.IFaceMicroblock && !((IMicroblock.IFaceMicroblock)slottedPart).isFaceHollow()) {
            return null;
        }
        if (container == null) {
            return null;
        }
        ISlottedPart part = container.getPartInSlot(PartSlot.CENTER);
        if (part instanceof CableMultipart) {
            return (CableMultipart)part;
        }
        return null;
    }

    public void refreshBounding() {
        float centerFirst = this.center - this.offset;
        double w = this.getCableType().cableThickness / 16.0 - 0.5;
        this.boundingBoxes[6] = new Vecs3dCube((double)centerFirst - w, (double)centerFirst - w, (double)centerFirst - w, (double)centerFirst + w, (double)centerFirst + w, (double)centerFirst + w);
        int i = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            double zMin1;
            double yMax1;
            double yMin1;
            double xMax1;
            double xMin1;
            double d = dir.func_82601_c() < 0 ? 0.0 : (xMin1 = dir.func_82601_c() == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double d2 = dir.func_82601_c() > 0 ? 1.0 : (xMax1 = dir.func_82601_c() == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            double d3 = dir.func_96559_d() < 0 ? 0.0 : (yMin1 = dir.func_96559_d() == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double d4 = dir.func_96559_d() > 0 ? 1.0 : (yMax1 = dir.func_96559_d() == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            double d5 = dir.func_82599_e() < 0 ? 0.0 : (zMin1 = dir.func_82599_e() == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double zMax1 = dir.func_82599_e() > 0 ? 1.0 : (dir.func_82599_e() == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            this.boundingBoxes[i] = new Vecs3dCube(xMin1, yMin1, zMin1, xMax1, yMax1, zMax1);
            ++i;
        }
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.connectedSides.containsKey(dir) || !mask.func_72326_a(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB())) continue;
            list.add(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB());
        }
        if (mask.func_72326_a(this.boundingBoxes[6].toAABB())) {
            list.add(this.boundingBoxes[6].toAABB());
        }
        super.addCollisionBoxes(mask, list, collidingEntity);
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.connectedSides.containsKey(dir)) continue;
            list.add(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB());
        }
        list.add(this.boundingBoxes[6].toAABB());
        super.addSelectionBoxes(list);
    }

    public void onRemoved() {
        super.onRemoved();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            CableMultipart multipart = CableMultipart.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(dir), dir);
            if (multipart == null) continue;
            multipart.nearByChange();
        }
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.connectedSides.containsKey(dir)) continue;
            list.add(this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB());
        }
        list.add(this.boundingBoxes[6].toAABB());
    }

    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.nearByChange();
    }

    public void nearByChange() {
        this.checkConnectedSides();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos blockPos = this.getPos().func_177972_a(direction);
            WorldUtils.updateBlock((World)this.getWorld(), (BlockPos)blockPos);
            CableMultipart part = CableMultipart.getPartFromWorld(this.getWorld(), blockPos, direction);
            if (part == null) continue;
            part.checkConnectedSides();
        }
    }

    public void onAdded() {
        this.checkConnectedSides();
    }

    public boolean shouldConnectTo(EnumFacing dir) {
        TileEntity tile;
        CableMultipart cableMultipart;
        return dir != null && (this.internalShouldConnectTo(dir) ? (cableMultipart = CableMultipart.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(dir), dir)) != null && cableMultipart.internalShouldConnectTo(dir.func_176734_d()) : (tile = this.getNeighbourTile(dir)) != null && tile.hasCapability(CapabilityEnergy.ENERGY, dir));
    }

    public boolean internalShouldConnectTo(EnumFacing dir) {
        ISlottedPart part = this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)dir));
        if (part instanceof IMicroblock.IFaceMicroblock && !((IMicroblock.IFaceMicroblock)part).isFaceHollow()) {
            return false;
        }
        if (!OcclusionHelper.occlusionTest((Iterable)this.getContainer().getParts(), p -> p == this, (AxisAlignedBB[])new AxisAlignedBB[]{this.boundingBoxes[Functions.getIntDirFromDirection((EnumFacing)dir)].toAABB()})) {
            return false;
        }
        CableMultipart cableMultipart = CableMultipart.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(dir), dir.func_176734_d());
        return cableMultipart != null && cableMultipart.getCableType() == this.getCableType();
    }

    public TileEntity getNeighbourTile(EnumFacing side) {
        return side != null ? this.getWorld().func_175625_s(this.getPos().func_177972_a(side)) : null;
    }

    public void checkConnectedSides() {
        this.refreshBounding();
        this.connectedSides = new HashMap<EnumFacing, BlockPos>();
        for (EnumFacing dir : EnumFacing.values()) {
            int d = Functions.getIntDirFromDirection((EnumFacing)dir);
            if (this.getWorld() == null) {
                return;
            }
            TileEntity te = this.getNeighbourTile(dir);
            if (!this.shouldConnectTo(dir)) continue;
            this.connectedSides.put(dir, te.func_174877_v());
        }
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.CENTER);
    }

    public void func_73660_a() {
        if (this.getWorld() != null) {
            ++this.ticks;
            if (this.getWorld().func_82737_E() % 80L == 0L) {
                this.checkConnectedSides();
            }
            this.tickPower();
        }
    }

    public void tickPower() {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int averPower;
            CableMultipart pipe;
            int move;
            IEnergyStorage energy;
            if (!this.connectedSides.containsKey(face)) continue;
            BlockPos offPos = this.getPos().func_177972_a(face);
            TileEntity tile = this.getWorld().func_175625_s(offPos);
            if (tile == null) continue;
            if (tile.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d()) && (energy = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d())).canReceive() && (move = energy.receiveEnergy(Math.min(this.getCableType().transferRate, this.power), false)) != 0) {
                this.power -= move;
            }
            if ((pipe = CableMultipart.getPartFromWorld(this.getWorld(), this.getPos().func_177972_a(face), face)) == null) continue;
            pipe.power = averPower = (this.power + pipe.power) / 2;
            if (averPower % 2 == 0 || this.power != 0) {
                // empty if block
            }
            this.power = ++averPower;
        }
    }

    public IBlockState getExtendedState(IBlockState state) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        return extendedBlockState.withProperty(DOWN, (Object)this.shouldConnectTo(EnumFacing.DOWN)).withProperty(UP, (Object)this.shouldConnectTo(EnumFacing.UP)).withProperty(NORTH, (Object)this.shouldConnectTo(EnumFacing.NORTH)).withProperty(SOUTH, (Object)this.shouldConnectTo(EnumFacing.SOUTH)).withProperty(WEST, (Object)this.shouldConnectTo(EnumFacing.WEST)).withProperty(EAST, (Object)this.shouldConnectTo(EnumFacing.EAST)).func_177226_a(TYPE, (Comparable)((Object)this.getCableType()));
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[]{TYPE}, new IUnlistedProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    public float getHardness(PartMOP hit) {
        return 0.5f;
    }

    public Material getMaterial() {
        return Material.field_151580_n;
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(TechRebornParts.cables, 1, this.getCableType().ordinal()));
        return list;
    }

    public void onEntityStanding(Entity entity) {
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return new ItemStack(TechRebornParts.cables, 1, this.getCableType().ordinal());
    }

    @Override
    public void addInfo(List<String> info) {
        info.add(TextFormatting.GREEN + "EU Transfer: " + TextFormatting.LIGHT_PURPLE + this.getCableType().transferRate);
        if (this.getCableType().canKill) {
            info.add(TextFormatting.RED + "Damages entity's!");
        }
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation("techreborn:cable");
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.power, Math.min(this.getCableType().transferRate * RebornCoreConfig.euPerFU, maxReceive));
        if (!simulate) {
            this.power += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.power, Math.min(this.getCableType().transferRate * RebornCoreConfig.euPerFU, maxExtract));
        if (!simulate) {
            this.power -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.power;
    }

    public int getMaxEnergyStored() {
        return this.getCableType().transferRate * 2;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }
}

