/*
 * Decompiled with CFR 0.152.
 */
package techreborn.proxies;

import java.io.File;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import reborncore.RebornCore;
import reborncore.api.tile.IUpgradeable;
import reborncore.client.hud.StackInfoElement;
import reborncore.client.hud.StackInfoHUD;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.common.blocks.BlockMachineBase;
import techreborn.Core;
import techreborn.blocks.BlockMachineCasing;
import techreborn.blocks.BlockMachineFrame;
import techreborn.blocks.BlockRubberLeaves;
import techreborn.client.ClientMultiBlocks;
import techreborn.client.IconSupplier;
import techreborn.client.RegisterItemJsons;
import techreborn.client.StackToolTipEvent;
import techreborn.client.gui.GuiBase;
import techreborn.client.keybindings.KeyBindings;
import techreborn.client.render.ModelDynamicCell;
import techreborn.client.render.entitys.RenderNukePrimed;
import techreborn.entitys.EntityNukePrimed;
import techreborn.init.ModBlocks;
import techreborn.items.ItemFrequencyTransmitter;
import techreborn.manual.loader.ManualLoader;
import techreborn.proxies.CommonProxy;

public class ClientProxy
extends CommonProxy {
    public static MultiblockRenderEvent multiblockRenderEvent;

    public static ResourceLocation getItemLocation(Item item) {
        ResourceLocation o = item.getRegistryName();
        if (o == null) {
            return null;
        }
        return o;
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return new ModelResourceLocation(location, "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        int i;
        super.preInit(event);
        StackInfoHUD.registerElement((StackInfoElement)new ItemFrequencyTransmitter.StackInfoFreqTransmitter());
        RenderingRegistry.registerEntityRenderingHandler(EntityNukePrimed.class, (IRenderFactory)new RenderManagerNuke());
        ManualLoader loader = new ManualLoader(new File(event.getModConfigurationDirectory(), "techreborn"));
        for (Object object : RebornCore.jsonDestroyer.objectsToDestroy) {
            if (!(object instanceof BlockMachineBase)) continue;
            BlockMachineBase base = (BlockMachineBase)object;
            this.registerItemModel(Item.func_150898_a((Block)base));
        }
        for (i = 0; i < BlockMachineCasing.types.length; ++i) {
            Core.proxy.registerSubBlockInventoryLocation(ModBlocks.MACHINE_CASINGS, i, "techreborn:machines/structure/machine_casing", "type=" + i);
        }
        for (i = 0; i < BlockMachineFrame.types.length; ++i) {
            Core.proxy.registerSubBlockInventoryLocation(ModBlocks.MACHINE_FRAMES, i, "techreborn:machines/storage/machine_blocks", "type=" + i);
        }
        ModelDynamicCell.init();
        RegisterItemJsons.registerModels();
    }

    @Override
    public void registerSubItemInventoryLocation(Item item, int meta, String location, String name) {
        ModelResourceLocation resourceLocation = new ModelResourceLocation(location, name);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resourceLocation);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new IconSupplier());
        MinecraftForge.EVENT_BUS.register((Object)new StackToolTipEvent());
        multiblockRenderEvent = new MultiblockRenderEvent();
        MinecraftForge.EVENT_BUS.register((Object)multiblockRenderEvent);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.config);
        ClientMultiBlocks.init();
        StateMap rubberLeavesStateMap = new StateMap.Builder().func_178442_a(new IProperty[]{BlockRubberLeaves.field_176236_b, BlockRubberLeaves.field_176237_a}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.RUBBER_LEAVES, (IStateMapper)rubberLeavesStateMap);
    }

    protected void registerItemModel(ItemStack item, String name) {
        ModelLoader.registerItemVariants((Item)item.func_77973_b(), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        ModelLoader.setCustomModelResourceLocation((Item)item.func_77973_b(), (int)item.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    public ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return ClientProxy.registerIt(item, itemLocation);
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        name = name.toLowerCase();
        super.registerFluidBlockRendering(block, name);
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("techreborn".toLowerCase() + ":fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void registerCustomBlockStateLocation(Block block, String resourceLocation) {
        resourceLocation = resourceLocation.toLowerCase();
        super.registerCustomBlockStateLocation(block, resourceLocation);
        final String finalResourceLocation = resourceLocation;
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b();
                String propertyString = this.func_178131_a((Map)state.func_177228_b());
                return new ModelResourceLocation(resourceDomain + ':' + finalResourceLocation, propertyString);
            }
        });
        String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).func_110624_b();
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(resourceDomain + ':' + resourceLocation, "inventory"));
    }

    @Override
    public void registerCustomBlockStateLocation(Block block, String resourceLocation, boolean item) {
        resourceLocation = resourceLocation.toLowerCase();
        super.registerCustomBlockStateLocation(block, resourceLocation, item);
        final String finalResourceLocation = resourceLocation;
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b();
                String propertyString = this.func_178131_a((Map)state.func_177228_b());
                return new ModelResourceLocation(resourceDomain + ':' + finalResourceLocation, propertyString);
            }
        });
        if (item) {
            String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).func_110624_b();
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(resourceDomain + ':' + resourceLocation, "inventory"));
        }
    }

    @Override
    public boolean isCTMAvailable() {
        return isChiselAround;
    }

    @Override
    public String getUpgradeConfigText() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiBase) {
            GuiBase base = (GuiBase)Minecraft.func_71410_x().field_71462_r;
            if (base.tile instanceof IUpgradeable && ((IUpgradeable)base.tile).canBeUpgraded()) {
                return TextFormatting.LIGHT_PURPLE + "Right click to configure";
            }
        }
        return super.getUpgradeConfigText();
    }

    public class RenderManagerNuke
    implements IRenderFactory<EntityNukePrimed> {
        public Render<? super EntityNukePrimed> createRenderFor(RenderManager manager) {
            return new RenderNukePrimed(manager);
        }
    }
}

