/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;

public class TileAesu
extends TilePowerAcceptor
implements IWrenchable {
    public static final int MAX_OUTPUT = ConfigTechReborn.AesuMaxOutput;
    public static final int MAX_STORAGE = ConfigTechReborn.AesuMaxStorage;
    public Inventory inventory = new Inventory(4, "TileAesu", 64, (TileEntity)this);
    private int OUTPUT = 64;
    private double euLastTick = 0.0;
    private double euChange;
    private int ticks;

    public TileAesu() {
        super(5);
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.ticks == ConfigTechReborn.AverageEuOutTickTime) {
            this.euChange = -1.0;
            this.ticks = 0;
        } else {
            ++this.ticks;
            this.euChange += this.getEnergy() - this.euLastTick;
            if (this.euLastTick == this.getEnergy()) {
                this.euChange = 0.0;
            }
        }
        this.euLastTick = this.getEnergy();
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return true;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public boolean isComplete() {
        return false;
    }

    public void handleGuiInputFromClient(int id) {
        if (id == 0) {
            this.OUTPUT += 256;
        }
        if (id == 1) {
            this.OUTPUT += 64;
        }
        if (id == 2) {
            this.OUTPUT -= 64;
        }
        if (id == 3) {
            this.OUTPUT -= 256;
        }
        if (this.OUTPUT > MAX_OUTPUT) {
            this.OUTPUT = MAX_OUTPUT;
        }
        if (this.OUTPUT <= -1) {
            this.OUTPUT = 0;
        }
    }

    public double getEuChange() {
        if (this.euChange == -1.0) {
            return -1.0;
        }
        return this.euChange / (double)this.ticks;
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.ADJUSTABLE_SU, 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.func_77978_p().func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74780_a("euChange", this.euChange);
        tagCompound.func_74780_a("euLastTick", this.euLastTick);
        tagCompound.func_74768_a("output", this.OUTPUT);
        this.inventory.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.euChange = nbttagcompound.func_74769_h("euChange");
        this.euLastTick = nbttagcompound.func_74769_h("euLastTick");
        this.OUTPUT = nbttagcompound.func_74762_e("output");
        this.inventory.readFromNBT(nbttagcompound);
    }

    public double getBaseMaxPower() {
        return MAX_STORAGE;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return this.getFacingEnum() != direction;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return this.getFacingEnum() == direction;
    }

    public double getBaseMaxOutput() {
        return this.OUTPUT;
    }

    public double getBaseMaxInput() {
        return 8192.0;
    }

    public EnumPowerTier getBaseTier() {
        return EnumPowerTier.EXTREME;
    }
}

