/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.PoweredItem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.items.DynamicCell;

public class TileCentrifuge
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IListInfoProvider,
IRecipeCrafterProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(11, "TileCentrifuge", 64, (TileEntity)this);
    public RecipeCrafter crafter;
    public int euTick = ConfigTechReborn.CentrifugeInputTick;

    public TileCentrifuge() {
        super(2);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.crafter = new RecipeCrafter(Reference.centrifugeRecipe, (TileEntity)this, 2, 4, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        IEnergyItemInfo item;
        ItemStack stack;
        super.updateEntity();
        this.crafter.updateEntity();
        this.charge(6);
        if (this.inventory.func_70301_a(6) != ItemStack.field_190927_a && (stack = this.inventory.func_70301_a(6)).func_77973_b() instanceof IEnergyItemInfo && (item = (IEnergyItemInfo)stack.func_77973_b()).canProvideEnergy(stack) && this.getEnergy() != this.getMaxPower()) {
            this.addEnergy(item.getMaxTransfer(stack));
            PoweredItem.setEnergy((double)(PoweredItem.getEnergy((ItemStack)stack) - item.getMaxTransfer(stack)), (ItemStack)stack);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.INDUSTRIAL_CENTRIFUGE, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray = nArray2;
            nArray2[5] = 5;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray = nArray3;
            nArray3[5] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return itemStackIn.func_77969_a(DynamicCell.getEmptyCell(1).func_77946_l()) ? index == 1 : index == 0;
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex >= 2 && slotIndex <= 5;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        super.addInfo(info, isRealTile);
        info.add("Round and round it goes");
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getBaseMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getBaseTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("centrifuge").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 40, 34).slot(1, 40, 54).outputSlot(2, 82, 44).outputSlot(3, 101, 25).outputSlot(4, 120, 44).outputSlot(5, 101, 63).energySlot(6, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create();
    }
}

