/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileRollingMachine
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public final InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingTileContainer(), 3, 3);
    public Inventory inventory = new Inventory(3, "TileRollingMachine", 64, (TileEntity)this);
    public boolean isRunning;
    public int tickTime;
    public int runTime = 250;
    public ItemStack currentRecipe;
    private int outputSlot = 0;
    public int euTick = 5;

    public TileRollingMachine() {
        super(1);
    }

    public double getBaseMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getBaseTier() {
        return EnumPowerTier.LOW;
    }

    public void updateEntity() {
        super.updateEntity();
        this.charge(2);
        if (!this.field_145850_b.field_72995_K) {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null && this.canMake() && this.tickTime >= this.runTime) {
                this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
                if (this.currentRecipe != null) {
                    boolean hasCrafted = false;
                    if (this.inventory.func_70301_a(this.outputSlot) == ItemStack.field_190927_a) {
                        this.inventory.func_70299_a(this.outputSlot, this.currentRecipe);
                        this.tickTime = -1;
                        hasCrafted = true;
                    } else if (this.inventory.func_70301_a(this.outputSlot).func_190916_E() + this.currentRecipe.func_190916_E() <= this.currentRecipe.func_77976_d()) {
                        ItemStack stack = this.inventory.func_70301_a(this.outputSlot);
                        stack.func_190920_e(stack.func_190916_E() + this.currentRecipe.func_190916_E());
                        this.inventory.func_70299_a(this.outputSlot, stack);
                        this.tickTime = -1;
                        hasCrafted = true;
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                            this.craftMatrix.func_70298_a(i, 1);
                        }
                        this.currentRecipe = null;
                    }
                }
            }
            if (this.currentRecipe != null && this.canUseEnergy(this.euTick) && this.tickTime < this.runTime) {
                this.useEnergy(this.euTick);
                ++this.tickTime;
            }
            if (this.currentRecipe == null) {
                this.tickTime = -1;
            }
        } else {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null) {
                this.inventory.func_70299_a(1, this.currentRecipe);
            } else {
                this.inventory.func_70299_a(1, ItemStack.field_190927_a);
            }
        }
    }

    public boolean canMake() {
        return RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b) != null;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ROLLING_MACHINE, 1);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        ItemUtils.readInvFromNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.isRunning = tagCompound.func_74767_n("isRunning");
        this.tickTime = tagCompound.func_74762_e("tickTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        ItemUtils.writeInvToNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.writeUpdateToNBT(tagCompound);
        return tagCompound;
    }

    public void writeUpdateToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("isRunning", this.isRunning);
        tagCompound.func_74768_a("tickTime", this.tickTime);
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side.equals((Object)EnumFacing.DOWN)) {
            return new int[]{0};
        }
        return new int[0];
    }

    public boolean func_180462_a(int Index, ItemStack itemStack, EnumFacing side) {
        return false;
    }

    public boolean func_180461_b(int Index, ItemStack itemStack, EnumFacing side) {
        return Index == this.outputSlot;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.tickTime;
    }

    public void setBurnTime(int burnTime) {
        this.tickTime = burnTime;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.tickTime == 0 || this.runTime == 0) {
            return 0;
        }
        return this.tickTime * scale / this.runTime;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("rollingmachine").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this.craftMatrix).slot(0, 30, 17).slot(1, 48, 17).slot(2, 66, 17).slot(3, 30, 35).slot(4, 48, 35).slot(5, 66, 35).slot(6, 30, 53).slot(7, 48, 53).slot(8, 66, 53).onCraft(inv -> this.inventory.func_70299_a(1, RollingMachineRecipe.instance.findMatchingRecipe((InventoryCrafting)inv, this.field_145850_b))).addInventory().tile((IInventory)this).outputSlot(0, 124, 35).energySlot(2, 8, 51).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).addInventory().create();
    }

    private static class RollingTileContainer
    extends Container {
        private RollingTileContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }
}

