/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.cable;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.common.RebornCoreConfig;
import techreborn.blocks.cable.BlockCable;
import techreborn.parts.powerCables.EnumCableType;

public class TileCable
extends TileEntity
implements ITickable,
IEnergyStorage {
    public int power = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int averPower;
            int move;
            IEnergyStorage energy;
            BlockPos offPos = this.func_174877_v().func_177972_a(face);
            TileEntity tile = this.func_145831_w().func_175625_s(offPos);
            if (tile == null) continue;
            if (!(tile instanceof TileCable) && tile.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d()) && (energy = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d())).canReceive() && (move = energy.receiveEnergy(Math.min(this.getCableType().transferRate, this.power), false)) != 0) {
                this.power -= move;
            }
            if (!(tile instanceof TileCable)) continue;
            TileCable cable = (TileCable)tile;
            cable.power = averPower = (this.power + cable.power) / 2;
            if (averPower % 2 == 0 || this.power != 0) {
                // empty if block
            }
            this.power = ++averPower;
        }
    }

    private EnumCableType getCableType() {
        return (EnumCableType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockCable.TYPE));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.power, Math.min(this.getCableType().transferRate * RebornCoreConfig.euPerFU, maxReceive));
        if (!simulate) {
            this.power += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.power, Math.min(this.getCableType().transferRate * RebornCoreConfig.euPerFU, maxExtract));
        if (!simulate) {
            this.power -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.power;
    }

    public int getMaxEnergyStored() {
        return this.getCableType().transferRate * 2;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

