/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.FluidGeneratorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;

public abstract class TileBaseFluidGenerator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider {
    private final FluidGeneratorRecipeList recipes;
    private final int euTick;
    public final Tank tank;
    public final Inventory inventory;
    double pendingWithdraw = 0.0;
    protected long lastOutput = 0L;
    private FluidGeneratorRecipe currentRecipe;

    public TileBaseFluidGenerator(EFluidGenerator type, int tier, String tileName, int tankCapacity, int euTick) {
        super(tier);
        this.recipes = GeneratorRecipeHelper.getFluidRecipesForGenerator(type);
        this.tank = new Tank(tileName, tankCapacity, (TileEntity)this);
        this.inventory = new Inventory(3, tileName, 64, (TileEntity)this);
        this.euTick = euTick;
    }

    public TileBaseFluidGenerator(EFluidGenerator type, EnumPowerTier tier, String tileName, int tankCapacity, int euTick) {
        this(type, tier.ordinal(), tileName, tankCapacity, euTick);
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && (this.acceptFluid() && FluidUtils.drainContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1) || FluidUtils.fillContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType()))) {
            this.syncWithAll();
        }
        if (this.tank.getFluidAmount() > 0) {
            if (this.currentRecipe == null || !this.currentRecipe.getFluid().equals(this.tank.getFluidType())) {
                this.currentRecipe = this.getRecipes().getRecipeForFluid(this.tank.getFluidType()).orElse(null);
            }
            if (this.currentRecipe != null && this.tryAddingEnergy(this.euTick)) {
                Integer euPerBucket = this.currentRecipe.getEnergyPerMb() * 1000;
                float millibucketsPerTick = 16000.0f / (float)euPerBucket.intValue();
                this.pendingWithdraw += (double)millibucketsPerTick;
                int currentWithdraw = (int)this.pendingWithdraw;
                this.pendingWithdraw -= (double)currentWithdraw;
                this.tank.drain(currentWithdraw, true);
                this.lastOutput = this.field_145850_b.func_82737_E();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() - this.lastOutput < 30L && !this.isActive()) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            } else if (this.field_145850_b.func_82737_E() - this.lastOutput > 30L && this.isActive()) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    protected boolean acceptFluid() {
        FluidStack stack;
        if (!this.func_70301_a(0).func_190926_b() && (stack = FluidUtils.getFluidStackInContainer((ItemStack)this.func_70301_a(0))) != null) {
            return this.recipes.getRecipeForFluid(stack.getFluid()).isPresent();
        }
        return false;
    }

    public FluidGeneratorRecipeList getRecipes() {
        return this.recipes;
    }

    public double getBaseMaxOutput() {
        return this.euTick;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getBaseTier() {
        return EnumPowerTier.values()[this.tier];
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }
}

