/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.ForgeModContainer;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileGenerator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public static int outputAmount = 10;
    public Inventory inventory = new Inventory(2, "TileGenerator", 64, (TileEntity)this);
    public int fuelSlot = 0;
    public int burnTime;
    public int totalBurnTime = 0;
    public boolean isBurning;
    public boolean lastTickBurning;
    ItemStack burnItem;

    public TileGenerator() {
        super(1);
    }

    public static int getItemBurnTime(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) / 4;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getEnergy() < this.getMaxPower()) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.addEnergy(outputAmount);
                this.isBurning = true;
            }
        } else {
            this.isBurning = false;
        }
        if (this.burnTime == 0) {
            this.updateState();
            this.burnTime = this.totalBurnTime = TileGenerator.getItemBurnTime(this.func_70301_a(this.fuelSlot));
            if (this.burnTime > 0) {
                this.updateState();
                this.burnItem = this.func_70301_a(this.fuelSlot);
                if (this.func_70301_a(this.fuelSlot).func_190916_E() == 1) {
                    if (this.func_70301_a(this.fuelSlot).func_77973_b() == Items.field_151129_at || this.func_70301_a(this.fuelSlot).func_77973_b() == ForgeModContainer.getInstance().universalBucket) {
                        this.func_70299_a(this.fuelSlot, new ItemStack(Items.field_151133_ar));
                    } else {
                        this.func_70299_a(this.fuelSlot, ItemStack.field_190927_a);
                    }
                } else {
                    this.func_70298_a(this.fuelSlot, 1);
                }
            }
        }
        this.lastTickBurning = this.isBurning;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (BlockStateContainer2.func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.func_177230_c();
            if ((Boolean)BlockStateContainer2.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != this.burnTime > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.burnTime > 0), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public double getBaseMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return 64.0;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getBaseTier() {
        return EnumPowerTier.LOW;
    }

    public ItemStack getWrenchDrop(EntityPlayer p0) {
        return new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("generator").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).fuelSlot(0, 80, 54).energySlot(1, 8, 72).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return TileGenerator.getItemBurnTime(itemStackIn) != 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{this.fuelSlot};
    }
}

