/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.tiles.multiblock.MultiblockChecker;

public class TileImplosionCompressor
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IRecipeCrafterProvider,
IContainerProvider {
    public Inventory inventory = new Inventory(4, "TileImplosionCompressor", 64, (TileEntity)this);
    public MultiblockChecker multiblockChecker;
    public RecipeCrafter crafter;

    public TileImplosionCompressor() {
        super(2);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.crafter = new RecipeCrafter(Reference.implosionCompressorRecipe, (TileEntity)this, 2, 2, this.inventory, inputs, outputs);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.multiblockChecker = new MultiblockChecker(this.field_145850_b, this.func_174877_v().func_177979_c(3));
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.IMPLOSION_COMPRESSOR, 1);
    }

    public boolean getMutliBlock() {
        boolean down = this.multiblockChecker.checkRectY(1, 1, 1, MultiblockChecker.ZERO_OFFSET);
        boolean up = this.multiblockChecker.checkRectY(1, 1, 1, new BlockPos(0, 2, 0));
        boolean chamber = this.multiblockChecker.checkRingYHollow(1, 1, 1, new BlockPos(0, 1, 0));
        return down && chamber && up;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.getMutliBlock()) {
            this.crafter.updateEntity();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 || index == 1;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 2 || index == 3;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getBaseMaxPower() {
        return 64000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getBaseTier() {
        return EnumPowerTier.MEDIUM;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("implosioncompressor").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).slot(0, 37, 26).slot(1, 37, 44).outputSlot(2, 93, 35).outputSlot(3, 111, 35).syncEnergyValue().syncCrafterValue().addInventory().create();
    }
}

