/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world.veins;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;

public class VeinInfo {
    private final float minSize;
    private final float maxSize;
    private final int minHeight;
    private final int maxHeight;
    private final int chance;
    private final ImmutableMap<Integer, IBlockState> veinBlocks;

    public VeinInfo(float minSize, float maxSize, int minHeight, int maxHeight, int chance, Map<Integer, IBlockState> veinBlocks) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.chance = chance;
        this.veinBlocks = ImmutableMap.copyOf(veinBlocks);
    }

    public float getMinSize() {
        return this.minSize;
    }

    public float getMaxSize() {
        return this.maxSize;
    }

    public float getRandomSize(Random random) {
        return this.minSize + random.nextFloat() * this.maxSize;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getRandomY(Random random, int boxHeight, int groundHeight) {
        int maxValue = groundHeight > this.maxHeight ? this.maxHeight : groundHeight;
        int randomY = (int)((float)this.minHeight + random.nextFloat() * (float)maxValue);
        if (randomY + boxHeight > maxValue) {
            return randomY - (boxHeight - (maxValue - randomY));
        }
        if (randomY - boxHeight < this.minHeight) {
            return randomY + (boxHeight - (randomY - this.minHeight));
        }
        return randomY;
    }

    public int getChance() {
        return this.chance;
    }

    public boolean shouldGenerate(Random random) {
        return this.chance >= random.nextInt(100);
    }

    public ImmutableMap<Integer, IBlockState> getVeinBlocks() {
        return this.veinBlocks;
    }
}

