/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.fluidreplicator;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.common.util.FluidUtils;
import techreborn.init.ModItems;
import techreborn.tiles.multiblock.TileFluidReplicator;

public class FluidReplicatorRecipe
implements Cloneable {
    @Nonnull
    private final int input;
    @Nonnull
    private final Fluid output;
    private final int tickTime;
    private final int euPerTick;

    public FluidReplicatorRecipe(int input, Fluid output, int tickTime, int euPerTick) {
        this.input = input;
        this.output = output;
        this.tickTime = tickTime;
        this.euPerTick = euPerTick;
    }

    public int getInput() {
        return this.input;
    }

    public Fluid getFluid() {
        return this.output;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getEuTick() {
        return this.euPerTick;
    }

    public List<Object> getInputs() {
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(new ItemStack(ModItems.UU_MATTER, this.input));
        return inputs;
    }

    public boolean useOreDic() {
        return false;
    }

    public boolean canCraft(TileFluidReplicator tile) {
        if (!tile.getMultiBlock()) {
            return false;
        }
        BlockPos hole = tile.func_174877_v().func_177967_a(tile.getFacing().func_176734_d(), 2);
        if (this.hasValidTank(tile.func_145831_w(), hole)) {
            return true;
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)tile.func_145831_w().func_180495_p(hole).func_177230_c());
        if (fluid == null) {
            return false;
        }
        if (!FluidUtils.fluidEquals((Fluid)fluid, (Fluid)this.output)) {
            return false;
        }
        Fluid tankFluid = tile.tank.getFluidType();
        return tankFluid == null || FluidUtils.fluidEquals((Fluid)tankFluid, (Fluid)fluid);
    }

    private boolean hasValidTank(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (fluidHandler != null) {
            FluidStack containedStack = fluidHandler.drain(1000, false);
            return containedStack != null && FluidUtils.fluidEquals((Fluid)containedStack.getFluid(), (Fluid)this.output);
        }
        return false;
    }

    public boolean onCraft(TileFluidReplicator tile) {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

