/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.rollingMachine;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import reborncore.common.util.StringUtils;
import techreborn.compat.jei.rollingMachine.RollingMachineRecipeWrapper;

public class RollingMachineRecipeCategory
implements IRecipeCategory<RollingMachineRecipeWrapper> {
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] OUTPUT_SLOTS = new int[]{10};
    private final IDrawable background;
    private final IDrawableAnimated progress;
    private final ICraftingGridHelper craftingGridHelper;
    private final String title;
    public static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/rolling_machine.png");

    public RollingMachineRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 29, 16, 116, 54);
        this.title = StringUtils.t((String)"tile.techreborn.rolling_machine.name");
        IDrawableStatic progressStatic = guiHelper.createDrawable(texture, 176, 14, 20, 18);
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, 250, IDrawableAnimated.StartDirection.LEFT, false);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(INPUT_SLOTS[0], OUTPUT_SLOTS[0]);
    }

    @Nonnull
    public String getUid() {
        return "TechReborn.RollingMachine";
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public String getModName() {
        return "Tech Reborn";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 62, 18);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RollingMachineRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                int i = k1 + l * 3;
                guiItemStacks.init(INPUT_SLOTS[i], true, k1 * 18, l * 18);
            }
        }
        guiItemStacks.init(OUTPUT_SLOTS[0], false, 94, 18);
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, ingredients.getInputs(VanillaTypes.ITEM));
        guiItemStacks.set(OUTPUT_SLOTS[0], (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

