/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.OreUtil;
import reborncore.common.util.RebornCraftingHelper;
import techreborn.Core;
import techreborn.api.recipe.machines.VacuumFreezerRecipe;
import techreborn.compat.CompatManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.init.fuels.DieselGeneratorFuels;
import techreborn.init.fuels.GasTurbineFuels;
import techreborn.init.fuels.PlasmaGeneratorFuels;
import techreborn.init.fuels.SemiFluidGeneratorFuels;
import techreborn.init.fuels.ThermalGeneratorFuels;
import techreborn.init.recipes.AlloySmelterRecipes;
import techreborn.init.recipes.AssemblingMachineRecipes;
import techreborn.init.recipes.BlastFurnaceRecipes;
import techreborn.init.recipes.CentrifugeRecipes;
import techreborn.init.recipes.ChemicalReactorRecipes;
import techreborn.init.recipes.CompressorRecipes;
import techreborn.init.recipes.CraftingTableRecipes;
import techreborn.init.recipes.DistillationTowerRecipes;
import techreborn.init.recipes.ExtractorRecipes;
import techreborn.init.recipes.FluidGeneratorRecipes;
import techreborn.init.recipes.FluidReplicatorRecipes;
import techreborn.init.recipes.FusionReactorRecipes;
import techreborn.init.recipes.GrinderRecipes;
import techreborn.init.recipes.ImplosionCompressorRecipes;
import techreborn.init.recipes.IndustrialElectrolyzerRecipes;
import techreborn.init.recipes.IndustrialGrinderRecipes;
import techreborn.init.recipes.IndustrialSawmillRecipes;
import techreborn.init.recipes.PlateBendingMachineRecipes;
import techreborn.init.recipes.RollingMachineRecipes;
import techreborn.init.recipes.ScrapboxRecipes;
import techreborn.init.recipes.SmeltingRecipes;
import techreborn.init.recipes.SolidCanningMachineRecipes;
import techreborn.init.recipes.WireMillRecipes;
import techreborn.items.ItemCells;
import techreborn.items.ingredients.ItemIngots;

@RebornRegistry(modID="techreborn")
public class ModRecipes {
    public static void init() {
        OreUtil.scanForOres();
        CompatManager.isQuantumStorageLoaded = Loader.isModLoaded((String)"quantumstorage");
        CraftingTableRecipes.init();
        SmeltingRecipes.init();
        RollingMachineRecipes.init();
        FluidGeneratorRecipes.init();
        IndustrialGrinderRecipes.init();
        IndustrialElectrolyzerRecipes.init();
        ImplosionCompressorRecipes.init();
        ScrapboxRecipes.init();
        FusionReactorRecipes.init();
        DistillationTowerRecipes.init();
        FluidReplicatorRecipes.init();
        BlastFurnaceRecipes.init();
        AlloySmelterRecipes.init();
        AssemblingMachineRecipes.init();
        CentrifugeRecipes.init();
        ChemicalReactorRecipes.init();
        CompressorRecipes.init();
        ExtractorRecipes.init();
        GrinderRecipes.init();
        PlateBendingMachineRecipes.init();
        SolidCanningMachineRecipes.init();
        WireMillRecipes.init();
        DieselGeneratorFuels.init();
        GasTurbineFuels.init();
        PlasmaGeneratorFuels.init();
        SemiFluidGeneratorFuels.init();
        ThermalGeneratorFuels.init();
        ModRecipes.addVacuumFreezerRecipes();
        ModRecipes.addIc2Recipes();
    }

    public static void postInit() {
        if (ConfigTechReborn.disableRailcraftSteelNuggetRecipe) {
            Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof ItemStack) || !(entry.getKey() instanceof ItemStack)) continue;
                ItemStack input = (ItemStack)entry.getKey();
                ItemStack output = (ItemStack)entry.getValue();
                if (!ItemUtils.isInputEqual((Object)"nuggetSteel", (ItemStack)output, (boolean)true, (boolean)true, (boolean)false) || !ItemUtils.isInputEqual((Object)"nuggetIron", (ItemStack)input, (boolean)true, (boolean)true, (boolean)false)) continue;
                Core.logHelper.info((Object)"Removing a steelnugget smelting recipe");
                iterator.remove();
            }
        }
        IndustrialSawmillRecipes.init();
        DieselGeneratorFuels.postInit();
        GasTurbineFuels.postInit();
        PlasmaGeneratorFuels.postInit();
        SemiFluidGeneratorFuels.postInit();
        ThermalGeneratorFuels.postInit();
    }

    static void addVacuumFreezerRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(new ItemStack(Blocks.field_150432_aD, 2), new ItemStack(Blocks.field_150403_cj), 60, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemIngots.getIngotByName("hot_tungstensteel"), ItemIngots.getIngotByName("tungstensteel"), 440, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("heliumplasma"), ItemCells.getCellByName("helium"), 440, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("water"), ItemCells.getCellByName("cell"), 60, 64));
    }

    static void addIc2Recipes() {
        RebornCraftingHelper.addShapelessOreRecipe((ItemStack)new ItemStack(ModItems.MANUAL), (Object[])new Object[]{"ingotRefinedIron", Items.field_151122_aG});
    }

    public static ItemStack getBucketWithFluid(Fluid fluid) {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
    }

    public static ItemStack getOre(String name) {
        if (OreDictionary.getOres((String)name).isEmpty()) {
            return new ItemStack(ModItems.MISSING_RECIPE_PLACEHOLDER);
        }
        return ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77946_l();
    }
}

