/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2591;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;

public class TechStorageBaseBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop,
IListInfoProvider {
    public final int maxCapacity;
    public final RebornInventory<TechStorageBaseBlockEntity> inventory;
    public class_1799 storedItem;

    public TechStorageBaseBlockEntity(class_2591<?> blockEntityTypeIn, String name, int maxCapacity) {
        super(blockEntityTypeIn);
        this.maxCapacity = maxCapacity;
        this.storedItem = class_1799.field_8037;
        this.inventory = new RebornInventory(3, name, maxCapacity, (MachineBaseBlockEntity)this);
    }

    public void readWithoutCoords(class_2487 tagCompound) {
        this.storedItem = class_1799.field_8037;
        if (tagCompound.method_10545("storedStack")) {
            this.storedItem = class_1799.method_7915((class_2487)tagCompound.method_10562("storedStack"));
        }
        if (!this.storedItem.method_7960()) {
            this.storedItem.method_7939(Math.min(tagCompound.method_10550("storedQuantity"), this.maxCapacity));
        }
        this.inventory.read(tagCompound);
    }

    public class_2487 writeWithoutCoords(class_2487 tagCompound) {
        if (!this.storedItem.method_7960()) {
            class_1799 temp = this.storedItem.method_7972();
            if (this.storedItem.method_7947() > this.storedItem.method_7914()) {
                temp.method_7939(this.storedItem.method_7914());
            }
            tagCompound.method_10566("storedStack", (class_2520)temp.method_7953(new class_2487()));
            tagCompound.method_10569("storedQuantity", Math.min(this.storedItem.method_7947(), this.maxCapacity));
        } else {
            tagCompound.method_10569("storedQuantity", 0);
        }
        this.inventory.write(tagCompound);
        return tagCompound;
    }

    public class_1799 getDropWithNBT() {
        class_2487 blockEntity = new class_2487();
        class_1799 dropStack = new class_1799((class_1935)this.getBlockType(), 1);
        this.writeWithoutCoords(blockEntity);
        dropStack.method_7980(new class_2487());
        dropStack.method_7969().method_10566("blockEntity", (class_2520)blockEntity);
        this.storedItem.method_7939(0);
        this.inventory.method_5447(1, class_1799.field_8037);
        this.syncWithAll();
        return dropStack;
    }

    public int getStoredCount() {
        return this.storedItem.method_7947();
    }

    public List<class_1799> getContentDrops() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (!this.getStoredItemType().method_7960()) {
            if (!this.inventory.method_5438(1).method_7960()) {
                stacks.add(this.inventory.method_5438(1));
            }
            int size = this.storedItem.method_7914();
            for (int i = 0; i < this.getStoredCount() / size; ++i) {
                class_1799 droped = this.storedItem.method_7972();
                droped.method_7939(size);
                stacks.add(droped);
            }
            if (this.getStoredCount() % size != 0) {
                class_1799 droped = this.storedItem.method_7972();
                droped.method_7939(this.getStoredCount() % size);
                stacks.add(droped);
            }
        }
        return stacks;
    }

    public void method_16896() {
        super.method_16896();
        if (!this.field_11863.field_9236) {
            class_1799 outputStack = class_1799.field_8037;
            if (!this.inventory.method_5438(1).method_7960()) {
                outputStack = this.inventory.method_5438(1);
            }
            if (!this.inventory.method_5438(0).method_7960() && this.storedItem.method_7947() + outputStack.method_7947() < this.maxCapacity) {
                class_1799 inputStack = this.inventory.method_5438(0);
                if (this.getStoredItemType().method_7960() || this.storedItem.method_7960() && ItemUtils.isItemEqual((class_1799)inputStack, (class_1799)outputStack, (boolean)true, (boolean)true)) {
                    this.storedItem = inputStack;
                    this.inventory.method_5447(0, class_1799.field_8037);
                } else if (ItemUtils.isItemEqual((class_1799)this.getStoredItemType(), (class_1799)inputStack, (boolean)true, (boolean)true)) {
                    int reminder = this.maxCapacity - this.storedItem.method_7947() - outputStack.method_7947();
                    if (inputStack.method_7947() <= reminder) {
                        this.setStoredItemCount(inputStack.method_7947());
                        this.inventory.method_5447(0, class_1799.field_8037);
                    } else {
                        this.setStoredItemCount(this.maxCapacity - outputStack.method_7947());
                        this.inventory.method_5438(0).method_7934(reminder);
                    }
                }
                this.method_5431();
                this.syncWithAll();
            }
            if (!this.storedItem.method_7960()) {
                if (outputStack.method_7960()) {
                    class_1799 delivered = this.storedItem.method_7972();
                    delivered.method_7939(Math.min(this.storedItem.method_7947(), delivered.method_7914()));
                    this.storedItem.method_7934(delivered.method_7947());
                    if (this.storedItem.method_7960()) {
                        this.storedItem = class_1799.field_8037;
                    }
                    this.inventory.method_5447(1, delivered);
                    this.method_5431();
                    this.syncWithAll();
                } else if (ItemUtils.isItemEqual((class_1799)this.storedItem, (class_1799)outputStack, (boolean)true, (boolean)true) && outputStack.method_7947() < outputStack.method_7914()) {
                    int wanted = Math.min(this.storedItem.method_7947(), outputStack.method_7914() - outputStack.method_7947());
                    outputStack.method_7939(outputStack.method_7947() + wanted);
                    this.storedItem.method_7934(wanted);
                    if (this.storedItem.method_7960()) {
                        this.storedItem = class_1799.field_8037;
                    }
                    this.method_5431();
                    this.syncWithAll();
                }
            }
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.readWithoutCoords(tagCompound);
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        this.writeWithoutCoords(tagCompound);
        return tagCompound;
    }

    public RebornInventory<TechStorageBaseBlockEntity> getInventory() {
        return this.inventory;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return this.getDropWithNBT();
    }

    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (isReal || hasData) {
            int size = 0;
            String name = "of nothing";
            if (!this.storedItem.method_7960()) {
                name = this.storedItem.method_7964().getString();
                size += this.storedItem.method_7947();
            }
            if (!this.inventory.method_5438(1).method_7960()) {
                name = this.inventory.method_5438(1).method_7964().getString();
                size += this.inventory.method_5438(1).method_7947();
            }
            info.add((class_2561)new class_2585(size + " " + name));
        }
    }

    public class_1799 getStoredItemType() {
        return this.storedItem.method_7960() ? this.inventory.method_5438(1) : this.storedItem;
    }

    public void setStoredItemCount(int amount) {
        this.storedItem.method_7933(amount);
        this.method_5431();
    }

    public void setStoredItemType(class_1799 type, int amount) {
        this.storedItem = type;
        this.storedItem.method_7939(amount);
        this.method_5431();
    }

    public int getMaxStoredCount() {
        return this.maxCapacity;
    }
}

