/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3518;
import org.apache.commons.lang3.Validate;
import reborncore.client.containerBuilder.builder.ContainerBlockEntityInventoryBuilder;
import reborncore.client.gui.builder.GuiBase;
import reborncore.common.util.serialization.SerializationUtil;
import techreborn.blockentity.data.SlotType;

public class DataDrivenSlot {
    private final int id;
    private final int x;
    private final int y;
    private final SlotType type;

    public static List<DataDrivenSlot> read(JsonArray jsonArray) {
        AtomicInteger idCount = new AtomicInteger();
        return SerializationUtil.stream((JsonArray)jsonArray).map(JsonElement::getAsJsonObject).map(json -> new DataDrivenSlot(idCount.getAndIncrement(), class_3518.method_15260((JsonObject)json, (String)"x"), class_3518.method_15260((JsonObject)json, (String)"y"), SlotType.fromString(class_3518.method_15265((JsonObject)json, (String)"type")))).collect(Collectors.toList());
    }

    public DataDrivenSlot(int id, int x, int y, SlotType type) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.type = type;
        Validate.notNull((Object)((Object)type));
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public SlotType getType() {
        return this.type;
    }

    public void add(ContainerBlockEntityInventoryBuilder inventoryBuilder) {
        this.type.getSlotBiConsumer().accept(inventoryBuilder, this);
    }

    @Environment(value=EnvType.CLIENT)
    public void draw(GuiBase<?> guiBase, GuiBase.Layer layer) {
        if (this.getType() == SlotType.OUTPUT) {
            guiBase.drawOutputSlot(this.getX(), this.getY(), layer);
        } else {
            guiBase.drawSlot(this.getX(), this.getY(), layer);
        }
    }
}

