/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.fusionReactor;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Torus;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class FusionControlComputerBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
IContainerProvider {
    public RebornInventory<FusionControlComputerBlockEntity> inventory;
    public int coilCount = 0;
    public int crafingTickTime = 0;
    public int finalTickTime = 0;
    public int neededPower = 0;
    public int size = 6;
    public int state = -1;
    int topStackSlot = 0;
    int bottomStackSlot = 1;
    int outputStackSlot = 2;
    FusionReactorRecipe currentRecipe = null;
    boolean hasStartedCrafting = false;
    long lastTick = -1L;

    public FusionControlComputerBlockEntity() {
        super(TRBlockEntities.FUSION_CONTROL_COMPUTER);
        this.checkOverfill = false;
        this.inventory = new RebornInventory(3, "FusionControlComputerBlockEntity", 64, (MachineBaseBlockEntity)this);
    }

    public boolean checkCoils() {
        List coils = Torus.generate((class_2338)this.field_11867, (int)this.size);
        for (class_2338 coilPos : coils) {
            if (this.isCoil(coilPos)) continue;
            this.coilCount = 0;
            return false;
        }
        this.coilCount = coils.size();
        return true;
    }

    public boolean isCoil(class_2338 pos) {
        return this.field_11863.method_8320(pos).method_11614() == TRContent.Machine.FUSION_COIL.block;
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.crafingTickTime = 0;
        this.finalTickTime = 0;
        this.neededPower = 0;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(class_1799 stack, int slot, boolean tags) {
        if (stack.method_7960()) {
            return true;
        }
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        return ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)stack, (boolean)true, (boolean)tags) && stack.method_7947() + this.inventory.method_5438(slot).method_7947() <= stack.method_7914();
    }

    public int getProgressScaled(int scale) {
        if (this.crafingTickTime != 0 && this.finalTickTime != 0) {
            return this.crafingTickTime * scale / this.finalTickTime;
        }
        return 0;
    }

    private void updateCurrentRecipe() {
        for (RebornRecipe recipe : ModRecipes.FUSION_REACTOR.getRecipes(this.method_10997())) {
            if (!recipe.canCraft((class_2586)this) || !this.validateRecipe((FusionReactorRecipe)recipe)) continue;
            this.currentRecipe = (FusionReactorRecipe)recipe;
            this.crafingTickTime = 0;
            this.finalTickTime = this.currentRecipe.getTime();
            this.neededPower = this.currentRecipe.getStartEnergy();
            this.hasStartedCrafting = false;
            break;
        }
    }

    private boolean validateRecipe(FusionReactorRecipe recipe) {
        return this.hasAllInputs(recipe) && this.canFitStack((class_1799)recipe.getOutputs().get(0), this.outputStackSlot, true);
    }

    private boolean hasAllInputs(RebornRecipe recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (RebornIngredient ingredient : recipeType.getRebornIngredients()) {
            boolean hasItem = false;
            if (ingredient.test(this.inventory.method_5438(this.topStackSlot)) || ingredient.test(this.inventory.method_5438(this.bottomStackSlot))) {
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private void useInput(int slot) {
        if (this.currentRecipe == null) {
            return;
        }
        for (RebornIngredient ingredient : this.currentRecipe.getRebornIngredients()) {
            if (!ingredient.test(this.inventory.method_5438(slot))) continue;
            this.inventory.shrinkSlot(slot, ingredient.getCount());
            break;
        }
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.lastTick == this.field_11863.method_8510()) {
            return;
        }
        this.lastTick = this.field_11863.method_8510();
        if (this.field_11863.method_8510() % 20L == 0L) {
            this.checkCoils();
            this.inventory.setChanged();
        }
        if (this.coilCount == 0) {
            this.resetCrafter();
            return;
        }
        if (this.currentRecipe == null && this.inventory.hasChanged()) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipe != null) {
            class_1799 result;
            if (!this.hasStartedCrafting && this.inventory.hasChanged() && !this.validateRecipe(this.currentRecipe)) {
                this.resetCrafter();
                return;
            }
            if (!this.hasStartedCrafting && this.canUseEnergy(this.currentRecipe.getStartEnergy())) {
                this.useEnergy(this.currentRecipe.getStartEnergy());
                this.hasStartedCrafting = true;
                this.useInput(this.topStackSlot);
                this.useInput(this.bottomStackSlot);
            }
            if (this.hasStartedCrafting && this.crafingTickTime < this.finalTickTime) {
                ++this.crafingTickTime;
                if (this.currentRecipe.getPower() > 0) {
                    this.addEnergy((double)this.currentRecipe.getPower() * this.getPowerMultiplier());
                    this.powerChange = (double)this.currentRecipe.getPower() * this.getPowerMultiplier();
                } else if (this.canUseEnergy(this.currentRecipe.getPower() * -1)) {
                    this.setEnergy(this.getEnergy() - (double)(this.currentRecipe.getPower() * -1));
                }
            } else if (this.crafingTickTime >= this.finalTickTime && this.canFitStack(result = (class_1799)this.currentRecipe.getOutputs().get(0), this.outputStackSlot, true)) {
                if (this.inventory.method_5438(this.outputStackSlot).method_7960()) {
                    this.inventory.method_5447(this.outputStackSlot, result.method_7972());
                } else {
                    this.inventory.shrinkSlot(this.outputStackSlot, -result.method_7947());
                }
                if (this.validateRecipe(this.currentRecipe)) {
                    this.crafingTickTime = 0;
                    this.useInput(this.topStackSlot);
                    this.useInput(this.bottomStackSlot);
                } else {
                    this.resetCrafter();
                }
            }
            this.method_5431();
        }
        this.inventory.resetChanged();
    }

    public double getPowerMultiplier() {
        double calc = 0.5 * Math.pow(this.size - 5, 1.8);
        return Math.max((double)Math.round(calc * 100.0) / 100.0, 1.0);
    }

    public double getBaseMaxPower() {
        return Math.min((double)TechRebornConfig.fusionControlComputerMaxEnergy * this.getPowerMultiplier(), 2.147483647E9);
    }

    public boolean canAcceptEnergy(class_2350 direction) {
        return direction != class_2350.field_11033 && direction != class_2350.field_11036;
    }

    public boolean canProvideEnergy(class_2350 direction) {
        return direction == class_2350.field_11033 || direction == class_2350.field_11036;
    }

    public double getBaseMaxOutput() {
        if (!this.hasStartedCrafting) {
            return 0.0;
        }
        return 2.147483647E9;
    }

    public double getBaseMaxInput() {
        if (this.hasStartedCrafting) {
            return 0.0;
        }
        return TechRebornConfig.fusionControlComputerMaxInput;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.crafingTickTime = tagCompound.method_10550("crafingTickTime");
        this.finalTickTime = tagCompound.method_10550("finalTickTime");
        this.neededPower = tagCompound.method_10550("neededPower");
        this.hasStartedCrafting = tagCompound.method_10577("hasStartedCrafting");
        if (tagCompound.method_10545("hasActiveRecipe") && tagCompound.method_10577("hasActiveRecipe") && this.currentRecipe == null) {
            for (RebornRecipe reactorRecipe : ModRecipes.FUSION_REACTOR.getRecipes(this.method_10997())) {
                if (!this.validateRecipe((FusionReactorRecipe)reactorRecipe)) continue;
                this.currentRecipe = (FusionReactorRecipe)reactorRecipe;
            }
        }
        if (tagCompound.method_10545("size")) {
            this.size = tagCompound.method_10550("size");
        }
        this.size = Math.min(this.size, TechRebornConfig.fusionControlComputerMaxCoilSize);
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10569("crafingTickTime", this.crafingTickTime);
        tagCompound.method_10569("finalTickTime", this.finalTickTime);
        tagCompound.method_10569("neededPower", this.neededPower);
        tagCompound.method_10556("hasStartedCrafting", this.hasStartedCrafting);
        tagCompound.method_10556("hasActiveRecipe", this.currentRecipe != null);
        tagCompound.method_10569("size", this.size);
        return tagCompound;
    }

    public void onLoad() {
        super.onLoad();
        this.checkCoils();
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return TRContent.Machine.FUSION_CONTROL_COMPUTER.getStack();
    }

    public RebornInventory<FusionControlComputerBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(int syncID, class_1657 player) {
        return new ContainerBuilder("fusionreactor").player(player.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 34, 47).slot(1, 126, 47).outputSlot(2, 80, 47).syncEnergyValue().syncIntegerValue(this::getCoilStatus, this::setCoilStatus).syncIntegerValue(this::getCrafingTickTime, this::setCrafingTickTime).syncIntegerValue(this::getFinalTickTime, this::setFinalTickTime).syncIntegerValue(this::getSize, this::setSize).syncIntegerValue(this::getState, this::setState).syncIntegerValue(this::getNeededPower, this::setNeededPower).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getCoilStatus() {
        return this.coilCount;
    }

    public void setCoilStatus(int coilStatus) {
        this.coilCount = coilStatus;
    }

    public int getCrafingTickTime() {
        return this.crafingTickTime;
    }

    public void setCrafingTickTime(int crafingTickTime) {
        this.crafingTickTime = crafingTickTime;
    }

    public int getFinalTickTime() {
        return this.finalTickTime;
    }

    public void setFinalTickTime(int finalTickTime) {
        this.finalTickTime = finalTickTime;
    }

    public int getNeededPower() {
        return this.neededPower;
    }

    public void setNeededPower(int neededPower) {
        this.neededPower = neededPower;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void changeSize(int sizeDelta) {
        int newSize = this.size + sizeDelta;
        this.size = Math.max(6, Math.min(TechRebornConfig.fusionControlComputerMaxCoilSize, newSize));
    }

    public int getState() {
        if (this.currentRecipe == null) {
            return 0;
        }
        if (!this.hasStartedCrafting) {
            return 1;
        }
        if (this.hasStartedCrafting) {
            return 2;
        }
        return -1;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getStateString() {
        if (this.state == -1) {
            return "";
        }
        if (this.state == 0) {
            return "No recipe";
        }
        if (this.state == 1) {
            return "Charging";
        }
        if (this.state == 2) {
            return "Crafting";
        }
        return "";
    }
}

