/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.generator;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.Validate;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.fluid.container.GenericFluidContainer;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.RebornInventory;
import reborncore.common.util.Tank;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.FluidGeneratorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.utils.FluidUtils;

public abstract class BaseFluidGeneratorBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider {
    private final FluidGeneratorRecipeList recipes;
    private final int euTick;
    private FluidGeneratorRecipe currentRecipe;
    private int ticksSinceLastChange;
    public final Tank tank;
    public final RebornInventory<?> inventory;
    protected long lastOutput = 0L;
    double pendingWithdraw = 0.0;

    public BaseFluidGeneratorBlockEntity(class_2591<?> blockEntityType, EFluidGenerator type, String blockEntityName, int tankCapacity, int euTick) {
        super(blockEntityType);
        this.recipes = GeneratorRecipeHelper.getFluidRecipesForGenerator(type);
        Validate.notNull((Object)this.recipes, (String)("null recipe list for " + type.getRecipeID()), (Object[])new Object[0]);
        this.tank = new Tank(blockEntityName, tankCapacity, (MachineBaseBlockEntity)this);
        this.inventory = new RebornInventory(3, blockEntityName, 64, (MachineBaseBlockEntity)this);
        this.euTick = euTick;
        this.ticksSinceLastChange = 0;
    }

    public void method_16896() {
        super.method_16896();
        ++this.ticksSinceLastChange;
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.ticksSinceLastChange >= 10) {
            class_1799 inputStack = this.inventory.method_5438(0);
            if (!inputStack.method_7960()) {
                if (FluidUtils.isContainerEmpty(inputStack) && this.tank.getFluidAmount() > 0) {
                    FluidUtils.fillContainers((GenericFluidContainer<class_2350>)this.tank, this.inventory, 0, 1, this.tank.getFluid());
                } else if (inputStack.method_7909() instanceof ItemFluidInfo && this.getRecipes().getRecipeForFluid(((ItemFluidInfo)inputStack.method_7909()).getFluid(inputStack)).isPresent()) {
                    FluidUtils.drainContainers((GenericFluidContainer<class_2350>)this.tank, this.inventory, 0, 1);
                }
            }
            this.ticksSinceLastChange = 0;
        }
        if (this.tank.getFluidAmount() > 0) {
            if (this.currentRecipe == null || !FluidUtils.fluidEquals(this.currentRecipe.getFluid(), this.tank.getFluid())) {
                this.currentRecipe = this.getRecipes().getRecipeForFluid(this.tank.getFluid()).orElse(null);
            }
            if (this.currentRecipe != null) {
                Integer euPerBucket = this.currentRecipe.getEnergyPerMb() * 1000;
                float millibucketsPerTick = (float)(this.euTick * 1000) / (float)euPerBucket.intValue();
                if (this.tryAddingEnergy(this.euTick)) {
                    this.pendingWithdraw += (double)millibucketsPerTick;
                    int currentWithdraw = (int)this.pendingWithdraw;
                    this.pendingWithdraw -= (double)currentWithdraw;
                    this.tank.getFluidInstance().subtractAmount(currentWithdraw);
                    this.lastOutput = this.field_11863.method_8510();
                }
            }
        }
        if (this.field_11863.method_8510() - this.lastOutput < 30L && !this.isActive()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
        } else if (this.field_11863.method_8510() - this.lastOutput > 30L && this.isActive()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public int getProgressScaled(int scale) {
        if (this.isActive()) {
            return this.ticksSinceLastChange * scale;
        }
        return 0;
    }

    protected boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    protected boolean acceptFluid() {
        FluidInstance stack;
        if (!this.inventory.method_5438(0).method_7960() && (stack = FluidUtils.getFluidStackInContainer(this.inventory.method_5438(0))) != null) {
            return this.recipes.getRecipeForFluid(stack.getFluid()).isPresent();
        }
        return false;
    }

    public FluidGeneratorRecipeList getRecipes() {
        return this.recipes;
    }

    public double getBaseMaxOutput() {
        return this.euTick;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public boolean canAcceptEnergy(class_2350 direction) {
        return false;
    }

    public boolean canProvideEnergy(class_2350 direction) {
        return true;
    }

    public RebornInventory<?> getInventory() {
        return this.inventory;
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.tank.read(tagCompound);
    }

    public class_2487 method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        this.tank.write(tagCompound);
        return tagCompound;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public int getTicksSinceLastChange() {
        return this.ticksSinceLastChange;
    }

    public void setTicksSinceLastChange(int ticksSinceLastChange) {
        this.ticksSinceLastChange = ticksSinceLastChange;
    }

    public int getTankAmount() {
        return this.tank.getFluidAmount();
    }

    public void setTankAmount(int amount) {
        this.tank.setFluidAmount(amount);
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

