/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.iron;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;

public abstract class AbstractIronMachineBlockEntity
extends MachineBaseBlockEntity
implements InventoryProvider,
IToolDrop {
    public RebornInventory<?> inventory;
    public int burnTime;
    public int totalBurnTime;
    public int progress;
    public int totalCookingTime;
    int fuelSlot;
    class_2248 toolDrop;
    boolean active = false;

    public AbstractIronMachineBlockEntity(class_2591<?> blockEntityTypeIn, int fuelSlot, class_2248 toolDrop) {
        super(blockEntityTypeIn);
        this.fuelSlot = fuelSlot;
        this.totalCookingTime = (int)(200.0 / TechRebornConfig.cookingScale);
        this.toolDrop = toolDrop;
    }

    protected abstract boolean canSmelt();

    protected abstract void smelt();

    private int getItemBurnTime(class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        return (int)((double)class_2609.method_11196().getOrDefault(stack.method_7909(), 0).intValue() * TechRebornConfig.fuelScale);
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * scale / this.totalBurnTime;
    }

    public int getProgressScaled(int scale) {
        if (this.totalCookingTime > 0) {
            return this.progress * scale / this.totalCookingTime;
        }
        return 0;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    private void updateState() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if (state.method_11614() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)state.method_11614();
            if ((Boolean)state.method_11654((class_2769)BlockMachineBase.ACTIVE) != this.burnTime > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.burnTime > 0), this.field_11863, this.field_11867);
            }
        }
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.burnTime = compoundTag.method_10550("BurnTime");
        this.totalBurnTime = compoundTag.method_10550("TotalBurnTime");
        this.progress = compoundTag.method_10550("Progress");
    }

    public class_2487 method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569("BurnTime", this.burnTime);
        compoundTag.method_10569("TotalBurnTime", this.totalBurnTime);
        compoundTag.method_10569("Progress", this.progress);
        return compoundTag;
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        boolean isBurning = this.isBurning();
        if (isBurning) {
            --this.burnTime;
        }
        if (!isBurning && this.canSmelt()) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.inventory.method_5438(this.fuelSlot));
            if (this.burnTime > 0) {
                class_1799 fuelStack = this.inventory.method_5438(this.fuelSlot);
                if (fuelStack.method_7909().method_7857()) {
                    this.inventory.method_5447(this.fuelSlot, new class_1799((class_1935)fuelStack.method_7909().method_7858()));
                } else if (fuelStack.method_7947() > 1) {
                    this.inventory.shrinkSlot(this.fuelSlot, 1);
                } else if (fuelStack.method_7947() == 1) {
                    this.inventory.method_5447(this.fuelSlot, class_1799.field_8037);
                }
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress == this.totalCookingTime) {
                this.progress = 0;
                this.smelt();
            }
        } else {
            this.progress = 0;
        }
        if (isBurning != this.isBurning()) {
            this.inventory.setChanged();
            this.updateState();
        }
        if (this.inventory.hasChanged()) {
            this.method_5431();
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public RebornInventory<?> getInventory() {
        return this.inventory;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return new class_1799((class_1935)this.toolDrop);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }
}

