/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.IInventoryAccess;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModSounds;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class AutoCraftingTableBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
IContainerProvider {
    public RebornInventory<AutoCraftingTableBlockEntity> inventory = new RebornInventory(11, "AutoCraftingTableBlockEntity", 64, (MachineBaseBlockEntity)this, AutoCraftingTableBlockEntity.getInventoryAccess());
    public int progress;
    public int maxProgress = 120;
    public int euTick = 10;
    class_1715 inventoryCrafting = null;
    class_3955 lastCustomRecipe = null;
    class_3955 lastRecipe = null;
    public boolean locked = true;

    public AutoCraftingTableBlockEntity() {
        super(TRBlockEntities.AUTO_CRAFTING_TABLE);
    }

    @Nullable
    public class_3955 getIRecipe() {
        class_1715 crafting = this.getCraftingInventory();
        if (!crafting.method_5442()) {
            if (this.lastRecipe != null && this.lastRecipe.method_8115((class_1263)crafting, this.field_11863)) {
                return this.lastRecipe;
            }
            Optional testRecipe = this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)crafting, this.field_11863);
            if (testRecipe.isPresent()) {
                this.lastRecipe = (class_3955)testRecipe.get();
                return this.lastRecipe;
            }
        }
        return null;
    }

    public class_1715 getCraftingInventory() {
        if (this.inventoryCrafting == null) {
            this.inventoryCrafting = new class_1715(new class_1703(null, -1){

                public boolean method_7597(class_1657 playerIn) {
                    return false;
                }
            }, 3, 3);
        }
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.method_5447(i, this.inventory.method_5438(i));
        }
        return this.inventoryCrafting;
    }

    public boolean canMake(class_3955 recipe) {
        if (recipe != null) {
            boolean missingOutput = false;
            int[] stacksInSlots = new int[9];
            for (int i = 0; i < 9; ++i) {
                stacksInSlots[i] = this.inventory.method_5438(i).method_7947();
            }
            class_2371 ingredients = recipe.method_8117();
            for (class_1856 ingredient : ingredients) {
                if (ingredient == class_1856.field_9017) continue;
                boolean foundIngredient = false;
                for (int i = 0; i < 9; ++i) {
                    int requiredSize;
                    class_1799 stack = this.inventory.method_5438(i);
                    int n = requiredSize = this.locked ? 1 : 0;
                    if (stack.method_7914() == 1) {
                        requiredSize = 0;
                    }
                    if (stacksInSlots[i] <= requiredSize || !ingredient.method_8093(stack) || stack.method_7909().method_7858() != null && !this.hasRoomForExtraItem(new class_1799((class_1935)stack.method_7909().method_7858()))) continue;
                    foundIngredient = true;
                    int n2 = i;
                    stacksInSlots[n2] = stacksInSlots[n2] - 1;
                    break;
                }
                if (foundIngredient) continue;
                missingOutput = true;
            }
            return !missingOutput && this.hasOutputSpace(recipe.method_8110(), 9);
        }
        return false;
    }

    boolean hasRoomForExtraItem(class_1799 stack) {
        class_1799 extraOutputSlot = this.inventory.method_5438(10);
        if (extraOutputSlot.method_7960()) {
            return true;
        }
        return this.hasOutputSpace(stack, 10);
    }

    public boolean hasOutputSpace(class_1799 output, int slot) {
        class_1799 stack = this.inventory.method_5438(slot);
        if (stack.method_7960()) {
            return true;
        }
        return ItemUtils.isItemEqual((class_1799)stack, (class_1799)output, (boolean)true, (boolean)true) && stack.method_7914() > stack.method_7947() + output.method_7947();
    }

    public boolean make(class_3955 recipe) {
        if (recipe == null || !this.canMake(recipe)) {
            return false;
        }
        block0: for (int i = 0; i < recipe.method_8117().size(); ++i) {
            class_1799 bestSlot;
            class_2371 ingredients = recipe.method_8117();
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8093(bestSlot = this.inventory.method_5438(i))) {
                this.handleContainerItem(bestSlot);
                bestSlot.method_7934(1);
                continue;
            }
            for (int j = 0; j < 9; ++j) {
                class_1799 stack = this.inventory.method_5438(j);
                if (!ingredient.method_8093(stack)) continue;
                this.handleContainerItem(stack);
                stack.method_7934(1);
                continue block0;
            }
        }
        class_1799 output = this.inventory.method_5438(9);
        class_1799 outputStack = recipe.method_8116((class_1263)this.getCraftingInventory());
        if (output.method_7960()) {
            this.inventory.method_5447(9, outputStack.method_7972());
        } else {
            output.method_7933(recipe.method_8110().method_7947());
        }
        return true;
    }

    private void handleContainerItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            class_1799 containerItem = new class_1799((class_1935)stack.method_7909().method_7858());
            class_1799 extraOutputSlot = this.inventory.method_5438(10);
            if (this.hasOutputSpace(containerItem, 10)) {
                if (extraOutputSlot.method_7960()) {
                    this.inventory.method_5447(10, containerItem.method_7972());
                } else if (ItemUtils.isItemEqual((class_1799)extraOutputSlot, (class_1799)containerItem, (boolean)true, (boolean)true) && extraOutputSlot.method_7914() < extraOutputSlot.method_7947() + containerItem.method_7947()) {
                    extraOutputSlot.method_7933(1);
                }
            }
        }
    }

    public boolean hasIngredient(class_1856 ingredient) {
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (!ingredient.method_8093(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemValidForRecipeSlot(class_1860<class_1715> recipe, class_1799 stack, int slotID) {
        if (recipe == null) {
            return true;
        }
        int bestSlot = this.findBestSlotForStack(recipe, stack);
        if (bestSlot != -1) {
            return bestSlot == slotID;
        }
        return true;
    }

    public int findBestSlotForStack(class_1860<class_1715> recipe, class_1799 stack) {
        if (recipe == null) {
            return -1;
        }
        class_2371 ingredients = recipe.method_8117();
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int i = 0; i < recipe.method_8117().size(); ++i) {
            class_1799 stackInSlot = this.inventory.method_5438(i);
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient == class_1856.field_9017 || !ingredient.method_8093(stack)) continue;
            if (stackInSlot.method_7960()) {
                possibleSlots.add(i);
                continue;
            }
            if (stackInSlot.method_7909() != stack.method_7909() || stackInSlot.method_7914() < stackInSlot.method_7947() + stack.method_7947()) continue;
            possibleSlots.add(i);
        }
        Pair smallestCount = null;
        for (Integer slot : possibleSlots) {
            class_1799 slotStack = this.inventory.method_5438(slot.intValue());
            if (slotStack.method_7960()) {
                return slot;
            }
            if (smallestCount == null) {
                smallestCount = Pair.of((Object)slot, (Object)slotStack.method_7947());
                continue;
            }
            if ((Integer)smallestCount.getRight() < slotStack.method_7947()) continue;
            smallestCount = Pair.of((Object)slot, (Object)slotStack.method_7947());
        }
        if (smallestCount != null) {
            return (Integer)smallestCount.getLeft();
        }
        return -1;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getMaxProgress() {
        if (this.maxProgress == 0) {
            this.maxProgress = 1;
        }
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        class_3955 recipe = this.getIRecipe();
        if (recipe != null) {
            if (this.progress >= this.maxProgress) {
                if (this.make(recipe)) {
                    this.progress = 0;
                }
            } else if (this.canMake(recipe)) {
                if (this.canUseEnergy(this.euTick)) {
                    ++this.progress;
                    if (this.progress == 1) {
                        this.field_11863.method_8465(null, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), ModSounds.AUTO_CRAFTING, class_3419.field_15245, 0.3f, 0.8f);
                    }
                    this.useEnergy(this.euTick);
                }
            } else {
                this.progress = 0;
            }
        }
        if (recipe == null) {
            this.progress = 0;
        }
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public double getBaseMaxPower() {
        return TechRebornConfig.autoCraftingTableMaxEnergy;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return TechRebornConfig.autoCraftingTableMaxInput;
    }

    public boolean canAcceptEnergy(class_2350 enumFacing) {
        return true;
    }

    public boolean canProvideEnergy(class_2350 enumFacing) {
        return false;
    }

    public class_2487 method_11007(class_2487 tag) {
        tag.method_10556("locked", this.locked);
        return super.method_11007(tag);
    }

    public void method_11014(class_2487 tag) {
        if (tag.method_10545("locked")) {
            this.locked = tag.method_10577("locked");
        }
        super.method_11014(tag);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    private static IInventoryAccess<AutoCraftingTableBlockEntity> getInventoryAccess() {
        return (slotID, stack, facing, direction, blockEntity) -> {
            switch (direction) {
                case INSERT: {
                    if (slotID > 8) {
                        return false;
                    }
                    int bestSlot = blockEntity.findBestSlotForStack((class_1860<class_1715>)blockEntity.getIRecipe(), stack);
                    if (bestSlot != -1) {
                        return slotID == bestSlot;
                    }
                    return true;
                }
                case EXTRACT: {
                    return slotID > 8;
                }
            }
            return true;
        };
    }

    public class_2350 getFacingEnum() {
        return class_2350.field_11043;
    }

    public class_1799 getToolDrop(class_1657 playerIn) {
        return TRContent.Machine.AUTO_CRAFTING_TABLE.getStack();
    }

    public RebornInventory<AutoCraftingTableBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(int syncID, class_1657 player) {
        return new ContainerBuilder("autocraftingtable").player(player.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 28, 25).slot(1, 46, 25).slot(2, 64, 25).slot(3, 28, 43).slot(4, 46, 43).slot(5, 64, 43).slot(6, 28, 61).slot(7, 46, 61).slot(8, 64, 61).outputSlot(9, 145, 42).outputSlot(10, 145, 70).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).syncIntegerValue(this::getMaxProgress, this::setMaxProgress).syncIntegerValue(this::getLockedInt, this::setLockedInt).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public boolean hasSlotConfig() {
        return false;
    }
}

