/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.idsu;

import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.checkerframework.checker.nullness.qual.NonNull;
import reborncore.common.util.NBTSerializable;
import reborncore.common.world.DataAttachment;
import reborncore.common.world.DataAttachmentProvider;

public class IDSUManager
implements DataAttachment {
    private final HashMap<String, IDSUPlayer> playerHashMap = new HashMap();

    public static @NonNull IDSUPlayer getPlayer(class_1937 world, String uuid) {
        return IDSUManager.get(world).getPlayer(uuid);
    }

    public static IDSUManager get(class_1937 world) {
        return (IDSUManager)DataAttachmentProvider.get((class_1937)world, IDSUManager.class);
    }

    public @NonNull IDSUPlayer getPlayer(String uuid) {
        return this.playerHashMap.computeIfAbsent(uuid, s -> new IDSUPlayer());
    }

    public void read(@NonNull class_2487 tag) {
        for (String uuid : tag.method_10541()) {
            this.playerHashMap.put(uuid, new IDSUPlayer(tag.method_10562(uuid)));
        }
    }

    public @NonNull class_2487 write() {
        class_2487 tag = new class_2487();
        this.playerHashMap.forEach((uuid, player) -> tag.method_10566(uuid, (class_2520)player.write()));
        return tag;
    }

    public static class IDSUPlayer
    implements NBTSerializable {
        private double energy;

        private IDSUPlayer() {
        }

        private IDSUPlayer(class_2487 compoundTag) {
            this.read(compoundTag);
        }

        public @NonNull class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10549("energy", this.energy);
            return tag;
        }

        public void read(@NonNull class_2487 tag) {
            this.energy = tag.method_10574("energy");
        }

        public double getEnergy() {
            return this.energy;
        }

        public void setEnergy(double energy) {
            this.energy = energy;
        }
    }
}

