/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_339;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.RebornCoreClient;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.widget.GuiButtonExtended;
import reborncore.client.gui.builder.widget.GuiButtonUpDown;
import reborncore.client.gui.guibuilder.GuiBuilder;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.common.network.NetworkManager;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.Color;
import reborncore.common.util.Torus;
import techreborn.blockentity.fusionReactor.FusionControlComputerBlockEntity;
import techreborn.init.TRContent;
import techreborn.packets.ServerboundPackets;

public class GuiFusionReactor
extends GuiBase<BuiltContainer> {
    FusionControlComputerBlockEntity blockEntity;

    public GuiFusionReactor(int syncID, class_1657 player, FusionControlComputerBlockEntity blockEntity) {
        super(player, (class_2586)blockEntity, (class_1703)blockEntity.createContainer(syncID, player));
        this.blockEntity = blockEntity;
    }

    public void init() {
        super.init();
        this.addButton((class_339)new GuiButtonUpDown(this.field_2776 + 121, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(5), GuiButtonUpDown.UpDownButtonType.FASTFORWARD));
        this.addButton((class_339)new GuiButtonUpDown(this.field_2776 + 121 + 12, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(1), GuiButtonUpDown.UpDownButtonType.FORWARD));
        this.addButton((class_339)new GuiButtonUpDown(this.field_2776 + 121 + 24, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(-5), GuiButtonUpDown.UpDownButtonType.REWIND));
        this.addButton((class_339)new GuiButtonUpDown(this.field_2776 + 121 + 36, this.field_2800 + 79, (GuiBase)this, buttonWidget -> this.sendSizeChange(-1), GuiButtonUpDown.UpDownButtonType.FASTREWIND));
    }

    protected void method_2389(float partialTicks, int mouseX, int mouseY) {
        super.method_2389(partialTicks, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(34, 47, layer);
        this.drawSlot(126, 47, layer);
        this.drawOutputSlot(80, 47, layer);
        this.builder.drawJEIButton((GuiBase)this, 158, 5, layer);
        if (this.blockEntity.getCoilStatus() > 0) {
            this.builder.drawHologramButton((GuiBase)this, 6, 4, mouseX, mouseY, layer);
        }
    }

    protected void method_2388(int mouseX, int mouseY) {
        super.method_2388(mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar((GuiBase)this, this.blockEntity.getProgressScaled(100), 100, 55, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        this.builder.drawProgressBar((GuiBase)this, this.blockEntity.getProgressScaled(100), 100, 105, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.LEFT, layer);
        if (this.blockEntity.getCoilStatus() > 0) {
            this.addHologramButton(6, 4, 212, layer).clickHandler(this::hologramToggle);
            this.drawCentredString(this.blockEntity.getStateString(), 20, Color.BLUE.darker().getColor(), layer);
            if (this.blockEntity.state == 2) {
                this.drawCentredString(PowerSystem.getLocaliszedPowerFormatted((int)((int)this.blockEntity.getPowerChange())) + "/t", 30, Color.GREEN.darker().getColor(), layer);
            }
        } else {
            this.builder.drawMultiblockMissingBar((GuiBase)this, layer);
            this.addHologramButton(76, 56, 212, layer).clickHandler(this::hologramToggle);
            this.builder.drawHologramButton((GuiBase)this, 76, 56, mouseX, mouseY, layer);
            Optional<Pair<Integer, Integer>> stackSize = this.getCoilStackCount();
            if (stackSize.isPresent()) {
                if ((Integer)stackSize.get().getLeft() > 0) {
                    this.drawCentredString("Required Coils: " + stackSize.get().getLeft() + "x64 +" + stackSize.get().getRight(), 25, 0xFFFFFF, layer);
                } else {
                    this.drawCentredString("Required Coils: " + stackSize.get().getRight(), 25, 0xFFFFFF, layer);
                }
            }
        }
        this.drawString("Size: " + this.blockEntity.size, 83, 81, 0xFFFFFF, layer);
        this.drawString("" + this.blockEntity.getPowerMultiplier() + "x", 10, 81, 0xFFFFFF, layer);
        this.builder.drawMultiEnergyBar((GuiBase)this, 9, 19, (int)this.blockEntity.getEnergy(), (int)this.blockEntity.getMaxPower(), mouseX, mouseY, 0, layer);
    }

    public void hologramToggle(GuiButtonExtended button, double x, double y) {
        if (GuiBase.slotConfigType == GuiBase.SlotConfigType.NONE) {
            if (RebornCoreClient.multiblockRenderEvent.currentMultiblock == null) {
                this.updateMultiBlockRender();
            } else {
                RebornCoreClient.multiblockRenderEvent.setMultiblock(null);
            }
        }
    }

    private void sendSizeChange(int sizeDelta) {
        NetworkManager.sendToServer(ServerboundPackets.createPacketFusionControlSize(sizeDelta, this.blockEntity.method_11016()));
        if (RebornCoreClient.multiblockRenderEvent.currentMultiblock != null) {
            this.updateMultiBlockRender();
        }
    }

    private void updateMultiBlockRender() {
        Multiblock multiblock = new Multiblock();
        class_2680 coil = TRContent.Machine.FUSION_COIL.block.method_9564();
        List coils = Torus.generate((class_2338)new class_2338(0, 0, 0), (int)this.blockEntity.size);
        coils.forEach(pos -> this.addComponent(pos.method_10263(), pos.method_10264(), pos.method_10260(), coil, multiblock));
        MultiblockSet set = new MultiblockSet(multiblock);
        RebornCoreClient.multiblockRenderEvent.setMultiblock(set);
        RebornCoreClient.multiblockRenderEvent.parent = this.blockEntity.method_11016();
        MultiblockRenderEvent.anchor = new class_2338(this.blockEntity.method_11016().method_10263(), this.blockEntity.method_11016().method_10264() - 1, this.blockEntity.method_11016().method_10260());
    }

    public void addComponent(int x, int y, int z, class_2680 blockState, Multiblock multiblock) {
        multiblock.addComponent(new class_2338(x, y, z), blockState);
    }

    public Optional<Pair<Integer, Integer>> getCoilStackCount() {
        if (!Torus.TORUS_SIZE_MAP.containsKey(this.blockEntity.size)) {
            return Optional.empty();
        }
        int count = (Integer)Torus.TORUS_SIZE_MAP.get(this.blockEntity.size);
        return Optional.of(Pair.of((Object)(count / 64), (Object)(count % 64)));
    }
}

