/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.RecipeDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import reborncore.common.crafting.RebornFluidRecipe;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;

public class MachineRecipeDisplay<R extends RebornRecipe>
implements RecipeDisplay {
    private final R recipe;
    private List<List<class_1799>> inputs;
    private List<class_1799> outputs;
    private int energy = 0;
    private int heat = 0;
    private FluidInstance fluidInstance = null;

    public MachineRecipeDisplay(R recipe) {
        this.recipe = recipe;
        this.inputs = recipe.getRebornIngredients().stream().map(RebornIngredient::getPreviewStacks).collect(Collectors.toList());
        this.outputs = recipe.getOutputs();
        this.energy = recipe.getPower();
        if (recipe instanceof BlastFurnaceRecipe) {
            this.heat = ((BlastFurnaceRecipe)((Object)recipe)).getHeat();
        }
        if (recipe instanceof RebornFluidRecipe) {
            this.fluidInstance = ((RebornFluidRecipe)recipe).getFluidInstance();
        }
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getHeat() {
        return this.heat;
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(this.recipe).map(RebornRecipe::method_8114);
    }

    public List<List<class_1799>> getInput() {
        return this.inputs;
    }

    public List<List<class_1799>> getRequiredItems() {
        return this.inputs;
    }

    public List<class_1799> getOutput() {
        return this.outputs;
    }

    public class_2960 getRecipeCategory() {
        return this.recipe.getRebornRecipeType().getName();
    }
}

