/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.util.version.VersionParsingException;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.RecipeManager;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.api.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.api.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.compat.rei.MachineRecipeCategory;
import techreborn.compat.rei.MachineRecipeDisplay;
import techreborn.compat.rei.fluidreplicator.FluidReplicatorRecipeCategory;
import techreborn.compat.rei.fluidreplicator.FluidReplicatorRecipeDisplay;
import techreborn.compat.rei.rollingmachine.RollingMachineCategory;
import techreborn.compat.rei.rollingmachine.RollingMachineDisplay;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;

public class ReiPlugin
implements REIPluginV0 {
    public static final class_2960 PLUGIN = new class_2960("techreborn", "techreborn_plugin");
    public static final Map<RebornRecipeType<?>, class_1935> iconMap = new HashMap();

    public ReiPlugin() {
        iconMap.put(ModRecipes.ALLOY_SMELTER, TRContent.Machine.ALLOY_SMELTER);
        iconMap.put(ModRecipes.ASSEMBLING_MACHINE, TRContent.Machine.ASSEMBLY_MACHINE);
        iconMap.put(ModRecipes.BLAST_FURNACE, TRContent.Machine.INDUSTRIAL_BLAST_FURNACE);
        iconMap.put(ModRecipes.CENTRIFUGE, TRContent.Machine.INDUSTRIAL_CENTRIFUGE);
        iconMap.put(ModRecipes.CHEMICAL_REACTOR, TRContent.Machine.CHEMICAL_REACTOR);
        iconMap.put(ModRecipes.COMPRESSOR, TRContent.Machine.COMPRESSOR);
        iconMap.put(ModRecipes.DISTILLATION_TOWER, TRContent.Machine.DISTILLATION_TOWER);
        iconMap.put(ModRecipes.EXTRACTOR, TRContent.Machine.EXTRACTOR);
        iconMap.put(ModRecipes.FLUID_REPLICATOR, TRContent.Machine.FLUID_REPLICATOR);
        iconMap.put(ModRecipes.FUSION_REACTOR, TRContent.Machine.FUSION_CONTROL_COMPUTER);
        iconMap.put(ModRecipes.GRINDER, TRContent.Machine.GRINDER);
        iconMap.put(ModRecipes.IMPLOSION_COMPRESSOR, TRContent.Machine.IMPLOSION_COMPRESSOR);
        iconMap.put(ModRecipes.INDUSTRIAL_ELECTROLYZER, TRContent.Machine.INDUSTRIAL_ELECTROLYZER);
        iconMap.put(ModRecipes.INDUSTRIAL_GRINDER, TRContent.Machine.INDUSTRIAL_GRINDER);
        iconMap.put(ModRecipes.INDUSTRIAL_SAWMILL, TRContent.Machine.INDUSTRIAL_SAWMILL);
        iconMap.put(ModRecipes.ROLLING_MACHINE, TRContent.Machine.ROLLING_MACHINE);
        iconMap.put(ModRecipes.SCRAPBOX, (class_1935)TRContent.SCRAP_BOX);
        iconMap.put(ModRecipes.SOLID_CANNING_MACHINE, TRContent.Machine.SOLID_CANNING_MACHINE);
        iconMap.put(ModRecipes.VACUUM_FREEZER, TRContent.Machine.VACUUM_FREEZER);
        iconMap.put(ModRecipes.WIRE_MILL, TRContent.Machine.WIRE_MILL);
    }

    public class_2960 getPluginIdentifier() {
        return PLUGIN;
    }

    public SemanticVersion getMinimumVersion() throws VersionParsingException {
        return SemanticVersion.parse((String)"3.0-pre");
    }

    public void registerPluginCategories(RecipeHelper recipeHelper) {
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.ALLOY_SMELTER));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.ASSEMBLING_MACHINE));
        recipeHelper.registerCategory(new MachineRecipeCategory<BlastFurnaceRecipe>(ModRecipes.BLAST_FURNACE));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.CENTRIFUGE, 4));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.CHEMICAL_REACTOR));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.COMPRESSOR, 1));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.DISTILLATION_TOWER, 3));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.EXTRACTOR, 1));
        recipeHelper.registerCategory((RecipeCategory)new FluidReplicatorRecipeCategory(ModRecipes.FLUID_REPLICATOR));
        recipeHelper.registerCategory(new MachineRecipeCategory<FusionReactorRecipe>(ModRecipes.FUSION_REACTOR, 2));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.GRINDER, 1));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.IMPLOSION_COMPRESSOR));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.INDUSTRIAL_ELECTROLYZER, 4));
        recipeHelper.registerCategory(new MachineRecipeCategory<IndustrialGrinderRecipe>(ModRecipes.INDUSTRIAL_GRINDER, 3));
        recipeHelper.registerCategory(new MachineRecipeCategory<IndustrialSawmillRecipe>(ModRecipes.INDUSTRIAL_SAWMILL, 3));
        recipeHelper.registerCategory((RecipeCategory)new RollingMachineCategory(ModRecipes.ROLLING_MACHINE));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.SCRAPBOX));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.SOLID_CANNING_MACHINE));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.VACUUM_FREEZER, 1));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.WIRE_MILL, 1));
    }

    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        RecipeManager.getRecipeTypes((String)"techreborn").forEach(rebornRecipeType -> this.registerMachineRecipe(recipeHelper, (RebornRecipeType)rebornRecipeType));
    }

    public void registerOthers(RecipeHelper recipeHelper) {
        recipeHelper.registerWorkingStations(ModRecipes.ALLOY_SMELTER.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.ALLOY_SMELTER.method_8389()), new class_1799((class_1935)TRContent.Machine.IRON_ALLOY_FURNACE.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.BLAST_FURNACE.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.INDUSTRIAL_BLAST_FURNACE.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.CENTRIFUGE.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.INDUSTRIAL_CENTRIFUGE.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.CHEMICAL_REACTOR.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.CHEMICAL_REACTOR.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.COMPRESSOR.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.COMPRESSOR.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.DISTILLATION_TOWER.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.DISTILLATION_TOWER.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.EXTRACTOR.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.EXTRACTOR.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.FLUID_REPLICATOR.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.FLUID_REPLICATOR.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.FUSION_REACTOR.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.FUSION_CONTROL_COMPUTER.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.GRINDER.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.GRINDER.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.IMPLOSION_COMPRESSOR.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.IMPLOSION_COMPRESSOR.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_ELECTROLYZER.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.INDUSTRIAL_ELECTROLYZER.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_GRINDER.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.INDUSTRIAL_GRINDER.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_SAWMILL.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.INDUSTRIAL_SAWMILL.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.ROLLING_MACHINE.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.ROLLING_MACHINE.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.SOLID_CANNING_MACHINE.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.SOLID_CANNING_MACHINE.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.VACUUM_FREEZER.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.VACUUM_FREEZER.method_8389())});
        recipeHelper.registerWorkingStations(ModRecipes.WIRE_MILL.getName(), new class_1799[]{new class_1799((class_1935)TRContent.Machine.WIRE_MILL.method_8389())});
    }

    private <R extends RebornRecipe> void registerMachineRecipe(RecipeHelper recipeHelper, RebornRecipeType<R> recipeType) {
        Function<RebornRecipe, RecipeDisplay> recipeDisplay = r -> new MachineRecipeDisplay<RebornRecipe>((RebornRecipe)r);
        if (recipeType == ModRecipes.ROLLING_MACHINE) {
            recipeDisplay = r -> {
                RollingMachineRecipe rollingMachineRecipe = (RollingMachineRecipe)((Object)r);
                return new RollingMachineDisplay(rollingMachineRecipe.getShapedRecipe());
            };
        }
        if (recipeType == ModRecipes.FLUID_REPLICATOR) {
            recipeDisplay = r -> {
                FluidReplicatorRecipe recipe = (FluidReplicatorRecipe)((Object)r);
                return new FluidReplicatorRecipeDisplay(recipe);
            };
        }
        recipeHelper.registerRecipes(recipeType.getName(), recipe -> {
            if (recipe instanceof RebornRecipe) {
                return ((RebornRecipe)recipe).getRebornRecipeType() == recipeType;
            }
            return false;
        }, recipeDisplay);
    }
}

