/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei.fluidreplicator;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.RecipeArrowWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.StringUtils;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.compat.rei.ReiPlugin;
import techreborn.compat.rei.fluidreplicator.FluidReplicatorRecipeDisplay;

public class FluidReplicatorRecipeCategory
implements RecipeCategory<FluidReplicatorRecipeDisplay> {
    private final RebornRecipeType<FluidReplicatorRecipe> rebornRecipeType;

    public FluidReplicatorRecipeCategory(RebornRecipeType<FluidReplicatorRecipe> recipeType) {
        this.rebornRecipeType = recipeType;
    }

    public class_2960 getIdentifier() {
        return this.rebornRecipeType.getName();
    }

    public String getCategoryName() {
        return StringUtils.t((String)this.rebornRecipeType.getName().toString());
    }

    public Renderer getIcon() {
        return Renderer.fromItemStack((class_1799)new class_1799((class_1935)ReiPlugin.iconMap.getOrDefault(this.rebornRecipeType, () -> class_1802.field_8250).method_8389()));
    }

    public List<Widget> setupDisplay(Supplier<FluidReplicatorRecipeDisplay> recipeDisplaySupplier, Rectangle bounds) {
        FluidReplicatorRecipeDisplay machineRecipe = recipeDisplaySupplier.get();
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 13);
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        widgets.add((Widget)new RecipeBaseWidget(bounds));
        widgets.add((Widget)new RecipeArrowWidget(startPoint.x + 24, startPoint.y + 1, true));
        int i = 0;
        for (List<class_1799> inputs : machineRecipe.getInput()) {
            widgets.add((Widget)new SlotWidget(startPoint.x + 1, startPoint.y + 1 + i++ * 20, (Renderer)Renderer.fromItemStacks(inputs), true, true, true));
        }
        class_2588 energyPerTick = new class_2588("techreborn.jei.recipe.running.cost", new Object[]{"E", machineRecipe.getEnergy()});
        widgets.add((Widget)new LabelWidget(startPoint.x + 1, startPoint.y + 1 + i++ * 20, energyPerTick.method_10863()){

            public void render(int mouseX, int mouseY, float delta) {
                this.font.method_1729(this.text, (float)(this.x - this.font.method_1727(this.text) / 2), (float)this.y, ScreenHelper.isDarkModeEnabled() ? -4473925 : -12566464);
            }
        });
        FluidInstance fluidInstance = machineRecipe.getFluidInstance();
        if (fluidInstance != null) {
            widgets.add((Widget)new SlotWidget(startPoint.x + 61, startPoint.y + 1, (Renderer)Renderer.fromFluid((class_3611)fluidInstance.getFluid()), true, true, true));
        }
        return widgets;
    }
}

