/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tool.industrial;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;
import techreborn.items.tool.ItemDrill;
import techreborn.utils.InitUtils;
import techreborn.utils.MessageIDs;

public class ItemIndustrialDrill
extends ItemDrill {
    public ItemIndustrialDrill() {
        super((class_1832)class_1834.field_8930, TechRebornConfig.industrialDrillCharge, 2.0f, 10.0f);
        this.cost = 250;
        this.transferLimit = 1000;
    }

    private Set<class_2338> getTargetBlocks(class_1937 worldIn, class_2338 pos, @Nullable class_1657 playerIn) {
        HashSet<class_2338> targetBlocks;
        block9: {
            class_2350 enumfacing;
            block10: {
                block8: {
                    targetBlocks = new HashSet<class_2338>();
                    if (playerIn == null) {
                        return new HashSet<class_2338>();
                    }
                    worldIn.method_8501(pos, class_2246.field_10566.method_9564());
                    class_239 hitResult = ItemIndustrialDrill.method_7872((class_1937)worldIn, (class_1657)playerIn, (class_3959.class_242)class_3959.class_242.field_1348);
                    worldIn.method_8501(pos, class_2246.field_10124.method_9564());
                    if (!(hitResult instanceof class_3965)) {
                        return Collections.emptySet();
                    }
                    enumfacing = ((class_3965)hitResult).method_17780();
                    if (enumfacing != class_2350.field_11035 && enumfacing != class_2350.field_11043) break block8;
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            class_2338 newPos = pos.method_10069(i, j, 0);
                            if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                            targetBlocks.add(newPos);
                        }
                    }
                    break block9;
                }
                if (enumfacing != class_2350.field_11034 && enumfacing != class_2350.field_11039) break block10;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        class_2338 newPos = pos.method_10069(0, j, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
                break block9;
            }
            if (enumfacing != class_2350.field_11033 && enumfacing != class_2350.field_11036) break block9;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    class_2338 newPos = pos.method_10069(j, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            }
        }
        return targetBlocks;
    }

    private void breakBlock(class_2338 pos, class_1937 world, class_1657 playerIn, class_1799 drill) {
        class_2680 blockState = world.method_8320(pos);
        if (Energy.of((Object)drill).use((double)this.cost)) {
            blockState.method_11614().method_9536(blockState, world, pos, blockState, true);
            blockState.method_11614().method_9556(world, playerIn, pos, blockState, world.method_8321(pos), drill);
            world.method_8501(pos, class_2246.field_10124.method_9564());
            world.method_8544(pos);
        }
    }

    private boolean shouldBreak(class_1657 playerIn, class_1937 worldIn, class_2338 originalPos, class_2338 pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        class_2680 blockState = worldIn.method_8320(pos);
        if (blockState.method_11620() == class_3614.field_15959) {
            return false;
        }
        if (blockState.method_11620().method_15797()) {
            return false;
        }
        float blockHardness = blockState.method_11589(playerIn, (class_1922)worldIn, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        float originalHardness = worldIn.method_8320(originalPos).method_11579((class_1922)worldIn, originalPos);
        return !(originalHardness / blockHardness > 10.0f);
    }

    @Override
    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 blockIn, class_2338 pos, class_1309 entityLiving) {
        class_1657 playerIn = null;
        if (entityLiving instanceof class_1657) {
            playerIn = (class_1657)entityLiving;
        }
        if (ItemUtils.isActive((class_1799)stack)) {
            for (class_2338 additionalPos : this.getTargetBlocks(worldIn, pos, playerIn)) {
                this.breakBlock(additionalPos, worldIn, playerIn, stack);
            }
        }
        return super.method_7879(stack, worldIn, blockIn, pos, entityLiving);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (Energy.of((Object)stack).getEnergy() < (double)this.cost) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (class_2561)new class_2585(class_124.field_1080 + StringUtils.t((String)"techreborn.message.nanosaberEnergyErrorTo") + " " + class_124.field_1065 + StringUtils.t((String)"techreborn.message.nanosaberActivate")));
            } else if (!ItemUtils.isActive((class_1799)stack)) {
                if (stack.method_7969() == null) {
                    stack.method_7980(new class_2487());
                }
                stack.method_7969().method_10556("isActive", true);
                if (world.field_9236) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (class_2561)new class_2585(class_124.field_1080 + StringUtils.t((String)"techreborn.message.setTo") + " " + class_124.field_1065 + StringUtils.t((String)"techreborn.message.nanosaberActive")));
                }
            } else {
                stack.method_7969().method_10556("isActive", false);
                if (world.field_9236) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (class_2561)new class_2585(class_124.field_1080 + StringUtils.t((String)"techreborn.message.setTo") + " " + class_124.field_1065 + StringUtils.t((String)"techreborn.message.nanosaberInactive")));
                }
            }
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        return new class_1271(class_1269.field_5811, (Object)stack);
    }

    public void method_7852(class_1937 world, class_1309 entity, class_1799 stack, int i) {
        if (ItemUtils.isActive((class_1799)stack) && Energy.of((Object)stack).getEnergy() < (double)this.cost) {
            if (entity.field_6002.field_9236) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (class_2561)new class_2585(class_124.field_1080 + StringUtils.t((String)"techreborn.message.nanosaberEnergyError") + " " + class_124.field_1065 + StringUtils.t((String)"techreborn.message.nanosaberDeactivating")));
            }
            stack.method_7969().method_10556("isActive", false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (!ItemUtils.isActive((class_1799)stack)) {
            tooltip.add((class_2561)new class_2585(class_124.field_1054 + "Shear: " + class_124.field_1061 + StringUtils.t((String)"techreborn.message.nanosaberInactive")));
        } else {
            tooltip.add((class_2561)new class_2585(class_124.field_1054 + "Shear: " + class_124.field_1060 + StringUtils.t((String)"techreborn.message.nanosaberActive")));
        }
    }

    public boolean method_7856(class_2680 blockIn) {
        return (class_1802.field_8377.method_7856(blockIn) || class_1802.field_8250.method_7856(blockIn)) && !class_1802.field_8556.method_7856(blockIn);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7850(class_1761 par2ItemGroup, class_2371<class_1799> itemList) {
        if (!this.method_7877(par2ItemGroup)) {
            return;
        }
        InitUtils.initPoweredItems(TRContent.INDUSTRIAL_DRILL, itemList);
    }
}

