/*
 * Decompiled with CFR 0.152.
 */
package techreborn.utils;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.checkerframework.checker.nullness.qual.NonNull;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.fluid.container.GenericFluidContainer;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.mixin.extensions.FluidBlockExtensions;

public class FluidUtils {
    public static @NonNull class_3611 fluidFromBlock(class_2248 block) {
        if (block instanceof FluidBlockExtensions) {
            return ((FluidBlockExtensions)block).getFluid();
        }
        return class_3612.field_15906;
    }

    public static List<class_3611> getAllFluids() {
        return class_2378.field_11154.method_10220().collect(Collectors.toList());
    }

    public static boolean drainContainers(GenericFluidContainer<class_2350> target, class_1263 inventory, int inputSlot, int outputSlot) {
        class_1799 inputStack = inventory.method_5438(inputSlot);
        class_1799 outputStack = inventory.method_5438(outputSlot);
        if (!(inputStack.method_7909() instanceof ItemFluidInfo)) {
            return false;
        }
        if (outputStack.method_7947() >= outputStack.method_7914()) {
            return false;
        }
        if (FluidUtils.isContainerEmpty(inputStack)) {
            return false;
        }
        ItemFluidInfo itemFluidInfo = (ItemFluidInfo)inputStack.method_7909();
        FluidInstance targetFluidInstance = target.getFluidInstance(null);
        class_3611 currentFluid = targetFluidInstance.getFluid();
        if (targetFluidInstance.isEmpty() || currentFluid == itemFluidInfo.getFluid(inputStack)) {
            int freeSpace = target.getCapacity(null) - targetFluidInstance.getAmount();
            if (!outputStack.method_7960() && outputStack.method_7947() + 1 >= outputStack.method_7914()) {
                return false;
            }
            if (freeSpace >= 1000) {
                inputStack.method_7934(1);
                targetFluidInstance.setFluid(itemFluidInfo.getFluid(inputStack));
                targetFluidInstance.addAmount(1000);
                if (outputStack.method_7960()) {
                    inventory.method_5447(outputSlot, itemFluidInfo.getEmpty());
                } else {
                    outputStack.method_7933(1);
                }
            }
        }
        return true;
    }

    public static boolean fillContainers(GenericFluidContainer<class_2350> source, class_1263 inventory, int inputSlot, int outputSlot, class_3611 fluidToFill) {
        class_1799 inputStack = inventory.method_5438(inputSlot);
        class_1799 outputStack = inventory.method_5438(outputSlot);
        if (!(inputStack.method_7909() instanceof ItemFluidInfo)) {
            return false;
        }
        if (!FluidUtils.isContainerEmpty(inputStack)) {
            return false;
        }
        ItemFluidInfo itemFluidInfo = (ItemFluidInfo)inputStack.method_7909();
        FluidInstance sourceFluid = source.getFluidInstance(null);
        if (sourceFluid.getFluid() == class_3612.field_15906 || sourceFluid.getAmount() < 1000) {
            return false;
        }
        if (!outputStack.method_7960()) {
            if (outputStack.method_7947() >= outputStack.method_7914()) {
                return false;
            }
            if (!(outputStack.method_7909() instanceof ItemFluidInfo)) {
                return false;
            }
            ItemFluidInfo outputFluidInfo = (ItemFluidInfo)outputStack.method_7909();
            if (outputFluidInfo.getFluid(outputStack) != sourceFluid.getFluid()) {
                return false;
            }
        }
        sourceFluid.subtractAmount(1000);
        if (outputStack.method_7960()) {
            inventory.method_5447(outputSlot, itemFluidInfo.getFull(sourceFluid.getFluid()));
        } else {
            outputStack.method_7933(1);
        }
        inputStack.method_7934(1);
        return false;
    }

    public static boolean fluidEquals(@NonNull class_3611 fluid, @NonNull class_3611 fluid1) {
        return fluid == fluid1;
    }

    public static FluidInstance getFluidStackInContainer(@NonNull class_1799 invStack) {
        return null;
    }

    public static boolean isContainerEmpty(class_1799 inputStack) {
        if (inputStack.method_7960()) {
            return false;
        }
        if (!(inputStack.method_7909() instanceof ItemFluidInfo)) {
            return false;
        }
        ItemFluidInfo itemFluidInfo = (ItemFluidInfo)inputStack.method_7909();
        return itemFluidInfo.getFluid(inputStack) == class_3612.field_15906;
    }
}

