/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3111;
import net.minecraft.class_3341;
import net.minecraft.class_3746;
import net.minecraft.class_3747;
import techreborn.blocks.misc.BlockRubberLog;
import techreborn.init.TRContent;

public class RubberTreeFeature
extends class_2944<class_3111> {
    private int treeBaseHeight = 5;
    private int sapRarity = 10;
    private int spireHeight = 4;

    public RubberTreeFeature(Function<Dynamic<?>, ? extends class_3111> featureConfig, boolean notify) {
        super(featureConfig, notify);
    }

    protected boolean method_12775(Set<class_2338> changedBlocks, class_3747 worldIn, Random rand, class_2338 saplingPos, class_3341 mutableBoundingBox) {
        int zOffset;
        int xOffset;
        int yOffset;
        int treeHeight = rand.nextInt(5) + this.treeBaseHeight;
        int baseY = saplingPos.method_10264();
        int baseX = saplingPos.method_10263();
        int baseZ = saplingPos.method_10260();
        if (baseY <= 1 && baseY + treeHeight + this.spireHeight + 1 >= 256) {
            return false;
        }
        if (!RubberTreeFeature.method_16433((class_3746)worldIn, (class_2338)saplingPos.method_10074())) {
            return false;
        }
        for (yOffset = baseY; yOffset <= baseY + 1 + treeHeight; ++yOffset) {
            int radius = 1;
            if (yOffset == baseY) {
                radius = 0;
            }
            if (yOffset >= baseY + 1 + treeHeight - 2) {
                radius = 2;
            }
            class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
            for (xOffset = baseX - radius; xOffset <= baseX + radius; ++xOffset) {
                for (zOffset = baseZ - radius; zOffset <= baseZ + radius; ++zOffset) {
                    if (RubberTreeFeature.method_16420((class_3746)worldIn, (class_2338)blockpos$mutable.method_10103(xOffset, yOffset, zOffset))) continue;
                    return false;
                }
            }
        }
        this.method_16427(worldIn, saplingPos.method_10074());
        class_2680 leafState = TRContent.RUBBER_LEAVES.method_9564();
        for (yOffset = baseY - 3 + treeHeight; yOffset <= baseY + treeHeight; ++yOffset) {
            int var12 = yOffset - (baseY + treeHeight);
            int center = 1 - var12 / 2;
            for (xOffset = baseX - center; xOffset <= baseX + center; ++xOffset) {
                int xPos = xOffset - baseX;
                int t = xPos >> 15;
                xPos = xPos + t ^ t;
                for (zOffset = baseZ - center; zOffset <= baseZ + center; ++zOffset) {
                    class_2338 leafPos;
                    int zPos = zOffset - baseZ;
                    if (!(xPos != center | (zPos = zPos + (t = zPos >> 31) ^ t) != center) && (rand.nextInt(2) == 0 || var12 == 0) || !RubberTreeFeature.method_16420((class_3746)worldIn, (class_2338)(leafPos = new class_2338(xOffset, yOffset, zOffset))) && !RubberTreeFeature.method_16425((class_3746)worldIn, (class_2338)leafPos)) continue;
                    this.method_12773(changedBlocks, (class_1945)worldIn, leafPos, leafState, mutableBoundingBox);
                }
            }
        }
        class_2338 currentLogPos = null;
        class_2680 logState = TRContent.RUBBER_LOG.method_9564();
        for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
            currentLogPos = saplingPos.method_10086(yOffset);
            if (!RubberTreeFeature.method_16420((class_3746)worldIn, (class_2338)currentLogPos)) continue;
            if (rand.nextInt(this.sapRarity) == 0) {
                logState = (class_2680)((class_2680)logState.method_11657((class_2769)BlockRubberLog.HAS_SAP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BlockRubberLog.SAP_SIDE, (Comparable)class_2350.method_10139((int)rand.nextInt(4)));
            }
            this.method_12773(changedBlocks, (class_1945)worldIn, currentLogPos, logState, mutableBoundingBox);
        }
        if (currentLogPos != null) {
            for (int i = 0; i < this.spireHeight; ++i) {
                class_2338 blockpos = currentLogPos.method_10086(i);
                this.method_12773(changedBlocks, (class_1945)worldIn, blockpos, leafState, mutableBoundingBox);
            }
        }
        return true;
    }
}

