/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class RecyclerBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
IContainerProvider,
SlotConfiguration.SlotFilter {
    private final RebornInventory<RecyclerBlockEntity> inventory = new RebornInventory(3, "RecyclerBlockEntity", 64, (MachineBaseBlockEntity)this);
    private final int cost = 2;
    private final int time = 15;
    private final int chance = 6;
    private boolean isBurning;
    private int progress;

    public RecyclerBlockEntity() {
        super(TRBlockEntities.RECYCLER);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / 15;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void recycleItems() {
        class_1799 itemstack = TRContent.Parts.SCRAP.getStack();
        int randomchance = this.field_11863.field_9229.nextInt(6);
        if (randomchance == 1) {
            if (this.inventory.method_5438(1).method_7960()) {
                this.inventory.method_5447(1, itemstack.method_7972());
            } else {
                this.inventory.method_5438(1).method_7933(itemstack.method_7947());
            }
        }
        this.inventory.shrinkSlot(0, 1);
    }

    public boolean canRecycle() {
        return !this.inventory.method_5438(0).method_7960() && this.hasSlotGotSpace(1);
    }

    public boolean hasSlotGotSpace(int slot) {
        if (this.inventory.method_5438(slot).method_7960()) {
            return true;
        }
        return this.inventory.method_5438(slot).method_7947() < this.inventory.method_5438(slot).method_7914();
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean burning) {
        this.isBurning = burning;
    }

    public void updateState() {
        class_2680 BlockStateContainer = this.field_11863.method_8320(this.field_11867);
        if (BlockStateContainer.method_11614() instanceof BlockMachineBase) {
            boolean shouldBurn;
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer.method_11614();
            boolean bl = shouldBurn = this.isBurning || this.canRecycle() && this.canUseEnergy(this.getEuPerTick(2.0));
            if ((Boolean)BlockStateContainer.method_11654((class_2769)BlockMachineBase.ACTIVE) != shouldBurn) {
                blockMachineBase.setActive(Boolean.valueOf(this.isBurning), this.field_11863, this.field_11867);
            }
        }
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        this.charge(2);
        boolean updateInventory = false;
        if (this.canRecycle() && !this.isBurning() && this.getEnergy() != 0.0) {
            this.setBurning(true);
        } else if (this.isBurning()) {
            if (this.useEnergy(this.getEuPerTick(2.0)) != this.getEuPerTick(2.0)) {
                this.setBurning(false);
            }
            ++this.progress;
            if (this.progress >= Math.max((int)(15.0 * (1.0 - this.getSpeedMultiplier())), 1)) {
                this.progress = 0;
                this.recycleItems();
                updateInventory = true;
                this.setBurning(false);
            }
        }
        this.updateState();
        if (updateInventory) {
            this.method_5431();
        }
    }

    public double getBaseMaxPower() {
        return TechRebornConfig.recyclerMaxEnergy;
    }

    public boolean canAcceptEnergy(class_2350 direction) {
        return true;
    }

    public boolean canProvideEnergy(class_2350 direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return TechRebornConfig.recyclerMaxInput;
    }

    public boolean canBeUpgraded() {
        return true;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return TRContent.Machine.RECYCLER.getStack();
    }

    public boolean isStackValid(int slotID, class_1799 stack) {
        if (slotID == 0) {
            return RecyclerBlockEntity.canRecycle(stack);
        }
        return false;
    }

    public int[] getInputSlots() {
        return new int[]{0};
    }

    public RebornInventory<RecyclerBlockEntity> getInventory() {
        return this.inventory;
    }

    public static boolean canRecycle(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof IUpgrade) {
            return false;
        }
        return !TechRebornConfig.recyclerBlackList.contains(class_2378.field_11142.method_10221((Object)item).toString());
    }

    public BuiltContainer createContainer(int syncID, class_1657 player) {
        return new ContainerBuilder("recycler").player(player.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 55, 45, RecyclerBlockEntity::canRecycle).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().sync(this::getProgress, this::setProgress).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

