/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier3;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class MatterFabricatorBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
IContainerProvider {
    public RebornInventory<MatterFabricatorBlockEntity> inventory = new RebornInventory(12, "MatterFabricatorBlockEntity", 64, (MachineBaseBlockEntity)this);
    private int amplifier = 0;

    public MatterFabricatorBlockEntity() {
        super(TRBlockEntities.MATTER_FABRICATOR);
    }

    private boolean spaceForOutput() {
        for (int i = 6; i < 11; ++i) {
            if (!this.spaceForOutput(i)) continue;
            return true;
        }
        return false;
    }

    private boolean spaceForOutput(int slot) {
        return this.inventory.method_5438(slot).method_7960() || ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)TRContent.Parts.UU_MATTER.getStack(), (boolean)true, (boolean)true) && this.inventory.method_5438(slot).method_7947() < 64;
    }

    private void addOutputProducts() {
        for (int i = 6; i < 11; ++i) {
            if (!this.spaceForOutput(i)) continue;
            this.addOutputProducts(i);
            break;
        }
    }

    private void addOutputProducts(int slot) {
        if (this.inventory.method_5438(slot).method_7960()) {
            this.inventory.method_5447(slot, TRContent.Parts.UU_MATTER.getStack());
        } else if (ItemUtils.isItemEqual((class_1799)this.inventory.method_5438(slot), (class_1799)TRContent.Parts.UU_MATTER.getStack(), (boolean)true, (boolean)true)) {
            this.inventory.method_5438(slot).method_7939(Math.min(64, 1 + this.inventory.method_5438(slot).method_7947()));
        }
    }

    public boolean decreaseStoredEnergy(double aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.getEnergy() - aEnergy < 0.0 && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setEnergy(this.getEnergy() - aEnergy);
        if (this.getEnergy() < 0.0) {
            this.setEnergy(0.0);
            return false;
        }
        return true;
    }

    public int getValue(class_1799 itemStack) {
        if (itemStack.method_7962(TRContent.Parts.SCRAP.getStack())) {
            return 200;
        }
        if (itemStack.method_7909() == TRContent.SCRAP_BOX) {
            return 2000;
        }
        return 0;
    }

    public int getProgress() {
        return this.amplifier;
    }

    public void setProgress(int progress) {
        this.amplifier = progress;
    }

    public int getProgressScaled(int scale) {
        if (this.amplifier != 0) {
            return Math.min(this.amplifier * scale / TechRebornConfig.matterFabricatorFabricationRate, 100);
        }
        return 0;
    }

    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        this.charge(11);
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (stack.method_7960() || !this.spaceForOutput()) continue;
            int amp = this.getValue(stack);
            int euNeeded = amp * TechRebornConfig.matterFabricatorEnergyPerAmp;
            if (amp == 0 || !this.canUseEnergy(euNeeded)) continue;
            this.useEnergy(euNeeded);
            this.amplifier += amp;
            this.inventory.shrinkSlot(i, 1);
        }
        if (this.amplifier >= TechRebornConfig.matterFabricatorFabricationRate && this.spaceForOutput()) {
            this.addOutputProducts();
            this.amplifier -= TechRebornConfig.matterFabricatorFabricationRate;
        }
    }

    public double getBaseMaxPower() {
        return TechRebornConfig.matterFabricatorMaxEnergy;
    }

    public boolean canAcceptEnergy(class_2350 direction) {
        return true;
    }

    public boolean canProvideEnergy(class_2350 direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return TechRebornConfig.matterFabricatorMaxInput;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return TRContent.Machine.MATTER_FABRICATOR.getStack();
    }

    public RebornInventory<MatterFabricatorBlockEntity> getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(int syncID, class_1657 player) {
        return new ContainerBuilder("matterfabricator").player(player.field_7514).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 30, 20).slot(1, 50, 20).slot(2, 70, 20).slot(3, 90, 20).slot(4, 110, 20).slot(5, 130, 20).outputSlot(6, 40, 66).outputSlot(7, 60, 66).outputSlot(8, 80, 66).outputSlot(9, 100, 66).outputSlot(10, 120, 66).energySlot(11, 8, 72).syncEnergyValue().sync(this::getProgress, this::setProgress).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

