/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.energy.lesu;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import team.reborn.energy.EnergyTier;
import techreborn.blockentity.storage.energy.EnergyStorageBlockEntity;
import techreborn.blockentity.storage.energy.lesu.LSUStorageBlockEntity;
import techreborn.blockentity.storage.energy.lesu.LesuNetwork;
import techreborn.blocks.storage.energy.LapotronicSUBlock;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class LapotronicSUBlockEntity
extends EnergyStorageBlockEntity
implements IContainerProvider {
    private int connectedBlocks = 0;
    private ArrayList<LesuNetwork> countedNetworks = new ArrayList();

    public LapotronicSUBlockEntity() {
        super(TRBlockEntities.LAPOTRONIC_SU, "LESU", 2, TRContent.Machine.LAPOTRONIC_SU.block, EnergyTier.LOW, TechRebornConfig.lesuStoragePerBlock);
        this.checkOverfill = false;
        this.maxOutput = TechRebornConfig.lesuBaseOutput;
    }

    private void setMaxStorage() {
        this.maxStorage = (this.connectedBlocks + 1) * TechRebornConfig.lesuStoragePerBlock;
        if (this.maxStorage < 0 || this.maxStorage > Integer.MAX_VALUE) {
            this.maxStorage = Integer.MAX_VALUE;
        }
    }

    private void setIORate() {
        this.maxOutput = TechRebornConfig.lesuBaseOutput + this.connectedBlocks * TechRebornConfig.lesuExtraIOPerBlock;
        if (this.connectedBlocks < 32) {
            return;
        }
        this.maxInput = this.connectedBlocks < 128 ? EnergyTier.MEDIUM.getMaxInput() : EnergyTier.HIGH.getMaxInput();
    }

    private void checkNetwork() {
        this.countedNetworks.clear();
        this.connectedBlocks = 0;
        for (class_2350 dir : class_2350.values()) {
            LesuNetwork network;
            class_2586 adjacent = this.field_11863.method_8321(this.field_11867.method_10093(dir));
            if (!(adjacent instanceof LSUStorageBlockEntity) || (network = ((LSUStorageBlockEntity)adjacent).network) == null || this.countedNetworks.contains(network) || network.master != null && network.master != this) continue;
            this.connectedBlocks += network.storages.size();
            this.countedNetworks.add(network);
            network.master = this;
            break;
        }
    }

    @Override
    public void method_16896() {
        super.method_16896();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.field_11863.method_8510() % 20L == 0L) {
            this.checkNetwork();
        }
        this.setMaxStorage();
        this.setIORate();
        if (this.getEnergy() > this.getMaxStoredPower()) {
            this.setEnergy(this.getMaxStoredPower());
        }
    }

    @Override
    public class_2350 getFacingEnum() {
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_11614();
        if (block instanceof LapotronicSUBlock) {
            return ((LapotronicSUBlock)block).getFacing(this.field_11863.method_8320(this.field_11867));
        }
        return null;
    }

    public BuiltContainer createContainer(int syncID, class_1657 player) {
        return new ContainerBuilder("lesu").player(player.field_7514).inventory().hotbar().armor().complete(8, 18).addArmor().addInventory().blockEntity((class_2586)this).energySlot(0, 62, 45).energySlot(1, 98, 45).syncEnergyValue().sync(this::getConnectedBlocksNum, this::setConnectedBlocksNum).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getConnectedBlocksNum() {
        return this.connectedBlocks;
    }

    public void setConnectedBlocksNum(int value) {
        this.connectedBlocks = value;
        if (this.field_11863.field_9236) {
            this.setMaxStorage();
            this.setIORate();
        }
    }
}

