/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.libcd;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import io.github.cottonmc.libcd.api.tweaker.Tweaker;
import io.github.cottonmc.libcd.api.tweaker.recipe.RecipeParser;
import io.github.cottonmc.libcd.api.tweaker.recipe.RecipeTweaker;
import io.github.cottonmc.libcd.api.tweaker.util.TweakerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.RecipeManager;
import reborncore.common.crafting.ingredient.FluidIngredient;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.api.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.api.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.compat.libcd.TRRecipeParser;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;

public class TRTweaker
implements Tweaker {
    public static final TRTweaker INSTANCE = new TRTweaker();
    private RecipeTweaker tweaker = RecipeTweaker.INSTANCE;
    private JsonObject debug;
    List<FluidGeneratorRecipe> added = new ArrayList<FluidGeneratorRecipe>();
    List<FluidGeneratorRecipe> toAdd = new ArrayList<FluidGeneratorRecipe>();

    public void prepareReload(class_3300 resourceManager) {
        this.debug = new JsonObject();
        for (FluidGeneratorRecipe recipe : this.added) {
            GeneratorRecipeHelper.removeFluidRecipe(recipe.getGeneratorType(), recipe.getFluid());
        }
        this.added.clear();
    }

    public void applyReload(class_3300 resourceManager, Executor executor) {
        for (FluidGeneratorRecipe recipe : this.toAdd) {
            if (GeneratorRecipeHelper.getFluidRecipesForGenerator(recipe.getGeneratorType()).addRecipe(recipe)) {
                this.added.add(recipe);
                String genID = recipe.getGeneratorType().getRecipeID();
                if (!this.debug.containsKey((Object)genID)) {
                    this.debug.put(genID, (JsonElement)new JsonArray());
                }
                JsonArray array = (JsonArray)this.debug.get((Object)genID);
                JsonObject recipeInfo = new JsonObject();
                recipeInfo.put("fluid", (JsonElement)new JsonPrimitive((Object)class_2378.field_11154.method_10221((Object)recipe.getFluid()).toString()));
                recipeInfo.put("energy_per_mb", (JsonElement)new JsonPrimitive((Object)(recipe.getEnergyPerBucket() / 1000)));
                array.add((JsonElement)recipeInfo);
                continue;
            }
            this.tweaker.getLogger().error("Could not add recipe to TechReborn generator " + recipe.getGeneratorType().getRecipeID() + ": a recipe for fluid " + class_2378.field_11154.method_10221((Object)recipe.getFluid()) + " already exists");
        }
        this.toAdd.clear();
    }

    public String getApplyMessage() {
        int recipeCount = this.added.size();
        return recipeCount + " TechReborn fluid generator " + (recipeCount == 1 ? "recipe" : "recipes");
    }

    public JsonObject getDebugInfo() {
        return this.debug;
    }

    public FluidIngredient createFluidIngredient(String fluid, String[] holders, int amount) {
        Optional<Object> parsedHolders;
        class_3611 parsedFluid = TweakerUtils.INSTANCE.getFluid(fluid);
        if (holders.length == 0) {
            parsedHolders = Optional.empty();
        } else {
            ArrayList<class_1792> items = new ArrayList<class_1792>();
            for (String holder : holders) {
                items.add(TweakerUtils.INSTANCE.getItem(holder));
            }
            parsedHolders = Optional.of(items);
        }
        Optional<Object> count = amount == -1 ? Optional.empty() : Optional.of(amount);
        return new FluidIngredient(parsedFluid, parsedHolders, count);
    }

    public void add(RebornRecipeType<?> type, Object[] inputs, Object[] outputs, int power, int time) {
        try {
            Object[] parsedOut = new class_1799[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                parsedOut[i] = RecipeParser.processItemStack((Object)outputs[i]);
            }
            class_2960 id = this.tweaker.getRecipeId(parsedOut[0]);
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            this.tweaker.addRecipe((class_1860)new RebornRecipe(type, id, ingredients, class_2371.method_10212((Object)class_1799.field_8037, (Object[])parsedOut), power, time));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn " + type.getName().method_12832().replace('_', ' ') + " recipe - " + e.getMessage());
        }
    }

    public void add(String type, Object[] inputs, Object[] outputs, int power, int time) {
        class_2960 id = type.contains(":") ? new class_2960(type) : new class_2960("techreborn", type);
        RebornRecipeType recipeType = RecipeManager.getRecipeType((class_2960)id);
        this.add(recipeType, inputs, outputs, power, time);
    }

    public void addAlloySmelter(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.ALLOY_SMELTER, inputs, outputs, power, time);
    }

    public void addAssemblingMachine(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.ASSEMBLING_MACHINE, inputs, outputs, power, time);
    }

    public void addBlastFurnace(Object[] inputs, Object[] outputs, int power, int time, int heat) {
        try {
            Object[] parsedOut = new class_1799[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                parsedOut[i] = RecipeParser.processItemStack((Object)outputs[i]);
            }
            class_2960 id = this.tweaker.getRecipeId(parsedOut[0]);
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            this.tweaker.addRecipe((class_1860)new BlastFurnaceRecipe(ModRecipes.BLAST_FURNACE, id, (class_2371<RebornIngredient>)ingredients, (class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])parsedOut), power, time, heat));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn blast furnace recipe - " + e.getMessage());
        }
    }

    public void addCentrifuge(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.CENTRIFUGE, inputs, outputs, power, time);
    }

    public void addChemicalReactor(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.CHEMICAL_REACTOR, inputs, outputs, power, time);
    }

    public void addCompressor(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.COMPRESSOR, inputs, outputs, power, time);
    }

    public void addDistillationTower(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.DISTILLATION_TOWER, inputs, outputs, power, time);
    }

    public void addExtractor(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.EXTRACTOR, inputs, outputs, power, time);
    }

    public void addGrinder(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.GRINDER, inputs, outputs, power, time);
    }

    public void addImplosionCompressor(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.IMPLOSION_COMPRESSOR, inputs, outputs, power, time);
    }

    public void addIndustrialElectrolyzer(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.INDUSTRIAL_ELECTROLYZER, inputs, outputs, power, time);
    }

    public void addIndustrialGrinder(Object[] inputs, Object[] outputs, int power, int time) {
        try {
            Object[] parsedOut = new class_1799[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                parsedOut[i] = RecipeParser.processItemStack((Object)outputs[i]);
            }
            class_2960 id = this.tweaker.getRecipeId(parsedOut[0]);
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            this.tweaker.addRecipe((class_1860)new IndustrialGrinderRecipe(ModRecipes.INDUSTRIAL_GRINDER, id, (class_2371<RebornIngredient>)ingredients, (class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])parsedOut), power, time));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn industrial grinder recipe - " + e.getMessage());
        }
    }

    public void addIndustrialGrinder(Object[] inputs, Object[] outputs, int power, int time, String fluid) {
        try {
            Object[] parsedOut = new class_1799[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                parsedOut[i] = RecipeParser.processItemStack((Object)outputs[i]);
            }
            class_2960 id = this.tweaker.getRecipeId(parsedOut[0]);
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            FluidInstance fluidInst = TRRecipeParser.parseFluid(fluid);
            this.tweaker.addRecipe((class_1860)new IndustrialGrinderRecipe(ModRecipes.INDUSTRIAL_GRINDER, id, (class_2371<RebornIngredient>)ingredients, (class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])parsedOut), power, time, fluidInst));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn industrial grinder recipe - " + e.getMessage());
        }
    }

    public void addIndustrialSawmill(Object[] inputs, Object[] outputs, int power, int time) {
        try {
            Object[] parsedOut = new class_1799[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                parsedOut[i] = RecipeParser.processItemStack((Object)outputs[i]);
            }
            class_2960 id = this.tweaker.getRecipeId(parsedOut[0]);
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            this.tweaker.addRecipe((class_1860)new IndustrialSawmillRecipe(ModRecipes.INDUSTRIAL_SAWMILL, id, (class_2371<RebornIngredient>)ingredients, (class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])parsedOut), power, time));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn industrial sawmill recipe - " + e.getMessage());
        }
    }

    public void addIndustrialSawmill(Object[] inputs, Object[] outputs, int power, int time, String fluid) {
        try {
            Object[] parsedOut = new class_1799[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                parsedOut[i] = RecipeParser.processItemStack((Object)outputs[i]);
            }
            class_2960 id = this.tweaker.getRecipeId(parsedOut[0]);
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            FluidInstance fluidInst = TRRecipeParser.parseFluid(fluid);
            this.tweaker.addRecipe((class_1860)new IndustrialSawmillRecipe(ModRecipes.INDUSTRIAL_SAWMILL, id, (class_2371<RebornIngredient>)ingredients, (class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])parsedOut), power, time, fluidInst));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn industrial sawmill recipe - " + e.getMessage());
        }
    }

    public void addRecycler(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.RECYCLER, inputs, outputs, power, time);
    }

    public void addScrapbox(Object output, int power, int time) {
        this.add(ModRecipes.SCRAPBOX, (Object[])new String[]{"techreborn:scrap_box"}, new Object[]{output}, power, time);
    }

    public void addVacuumFreezer(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.VACUUM_FREEZER, inputs, outputs, power, time);
    }

    public void addFluidReplicator(Object[] inputs, int power, int time, String fluid) {
        try {
            class_2960 id = this.tweaker.getRecipeId(new class_1799((class_1935)TRContent.Parts.UU_MATTER));
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            FluidInstance fluidInst = TRRecipeParser.parseFluid(fluid);
            this.tweaker.addRecipe((class_1860)new FluidReplicatorRecipe(ModRecipes.FLUID_REPLICATOR, id, (class_2371<RebornIngredient>)ingredients, (class_2371<class_1799>)class_2371.method_10211(), power, time, fluidInst));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn fluid replicator recipe - " + e.getMessage());
        }
    }

    public void addFusionReactor(Object[] inputs, Object[] outputs, int power, int time, int startE, int minSize) {
        try {
            Object[] parsedOut = new class_1799[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                parsedOut[i] = RecipeParser.processItemStack((Object)outputs[i]);
            }
            class_2960 id = this.tweaker.getRecipeId(parsedOut[0]);
            class_2371 ingredients = class_2371.method_10211();
            for (Object input : inputs) {
                ingredients.add((Object)TRRecipeParser.processIngredient(input));
            }
            this.tweaker.addRecipe((class_1860)new FusionReactorRecipe(ModRecipes.FUSION_REACTOR, id, (class_2371<RebornIngredient>)ingredients, (class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])parsedOut), power, time, startE, minSize));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn fusion reactor recipe - " + e.getMessage());
        }
    }

    public void addRollingMachine(Object[][] inputs, Object output) {
        try {
            Object[] processed = RecipeParser.processGrid((Object[][])inputs);
            int width = inputs[0].length;
            int height = inputs.length;
            this.addRollingMachine(processed, output, width, height);
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn 2D array rolling machine recipe - " + e.getMessage());
        }
    }

    public void addRollingMachine(Object[] inputs, Object output, int width, int height) {
        try {
            class_1799 out = RecipeParser.processItemStack((Object)output);
            class_2960 recipeId = this.tweaker.getRecipeId(out);
            class_2371 ingredients = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            for (int i = 0; i < Math.min(inputs.length, width * height); ++i) {
                Object id = inputs[i];
                if (id == null || id.equals("") || id.equals("minecraft:air")) continue;
                ingredients.set(i, (Object)RecipeParser.processIngredient((Object)id));
            }
            this.tweaker.addRecipe((class_1860)new RollingMachineRecipe(ModRecipes.ROLLING_MACHINE, recipeId, new class_1869(recipeId, "", width, height, ingredients, out)));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn 1D array rolling machine recipe - " + e.getMessage());
        }
    }

    public void addDictRollingMachine(String[] pattern, Map<String, Object> dictionary, Object output) {
        try {
            class_1799 out = RecipeParser.processItemStack((Object)output);
            class_2960 recipeId = this.tweaker.getRecipeId(out);
            pattern = RecipeParser.processPattern((String[])pattern);
            Map map = RecipeParser.processDictionary(dictionary);
            int x = pattern[0].length();
            int y = pattern.length;
            class_2371 ingredients = RecipeParser.getIngredients((String[])pattern, (Map)map, (int)x, (int)y);
            this.tweaker.addRecipe((class_1860)new RollingMachineRecipe(ModRecipes.ROLLING_MACHINE, recipeId, new class_1869(recipeId, "", x, y, ingredients, out)));
        }
        catch (Exception e) {
            this.tweaker.getLogger().error("Error parsing TechReborn dictionary rolling machine recipe - " + e.getMessage());
        }
    }

    public void addSolidCanningMachine(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.SOLID_CANNING_MACHINE, inputs, outputs, power, time);
    }

    public void addWireMill(Object[] inputs, Object[] outputs, int power, int time) {
        this.add(ModRecipes.WIRE_MILL, inputs, outputs, power, time);
    }

    public void addFluidGenerator(String generator, String fluid, int euPerMB) {
        EFluidGenerator type;
        switch (generator.toLowerCase()) {
            case "thermal": 
            case "techreborn.thermalgenerator": {
                type = EFluidGenerator.THERMAL;
                break;
            }
            case "gas": 
            case "techreborn.gasgenerator": {
                type = EFluidGenerator.GAS;
                break;
            }
            case "diesel": 
            case "techreborn.dieselgenerator": {
                type = EFluidGenerator.DIESEL;
                break;
            }
            case "semifluid": 
            case "techreborn.semifluidgenerator": {
                type = EFluidGenerator.SEMIFLUID;
                break;
            }
            case "plasma": 
            case "techreborn.plasmagenerator": {
                type = EFluidGenerator.PLASMA;
                break;
            }
            default: {
                this.tweaker.getLogger().error("Error parsing TechReborn fluid generator recipe - could not find generator: " + generator);
                return;
            }
        }
        class_3611 parsedFluid = TweakerUtils.INSTANCE.getFluid(fluid);
        if (parsedFluid == class_3612.field_15906) {
            this.tweaker.getLogger().error("Error parsing TechReborn fluid generator recipe - could not find fluid: " + fluid);
            return;
        }
        this.toAdd.add(new FluidGeneratorRecipe(parsedFluid, euPerMB, type));
    }
}

