/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.entries.SimpleRecipeEntry;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.RecipeArrowWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.util.StringUtils;
import techreborn.compat.rei.MachineRecipeDisplay;
import techreborn.compat.rei.ReiPlugin;

public class MachineRecipeCategory<R extends RebornRecipe>
implements RecipeCategory<MachineRecipeDisplay<R>> {
    private final RebornRecipeType<R> rebornRecipeType;
    private int recipeLines;

    MachineRecipeCategory(RebornRecipeType<R> rebornRecipeType) {
        this(rebornRecipeType, 2);
    }

    MachineRecipeCategory(RebornRecipeType<R> rebornRecipeType, int lines) {
        this.rebornRecipeType = rebornRecipeType;
        this.recipeLines = lines;
    }

    public class_2960 getIdentifier() {
        return this.rebornRecipeType.getName();
    }

    public String getCategoryName() {
        return StringUtils.t((String)this.rebornRecipeType.getName().toString());
    }

    public EntryStack getLogo() {
        return EntryStack.create((class_1935)ReiPlugin.iconMap.getOrDefault(this.rebornRecipeType, () -> class_1802.field_8250));
    }

    public RecipeEntry getSimpleRenderer(MachineRecipeDisplay<R> recipe) {
        return SimpleRecipeEntry.create(Collections.singletonList(recipe.getInputEntries().get(0)), recipe.getOutputEntries());
    }

    public List<Widget> setupDisplay(Supplier<MachineRecipeDisplay<R>> recipeDisplaySupplier, Rectangle bounds) {
        MachineRecipeDisplay<R> machineRecipe = recipeDisplaySupplier.get();
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - this.recipeLines * 12 - 1);
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        widgets.add((Widget)new RecipeBaseWidget(bounds));
        widgets.add((Widget)RecipeArrowWidget.create((Point)new Point(startPoint.x + 24, startPoint.y + 1), (boolean)true).time((double)machineRecipe.getTime() * 50.0));
        int i = 0;
        for (List<EntryStack> inputs : machineRecipe.getInputEntries()) {
            widgets.add((Widget)EntryWidget.create((int)(startPoint.x + 1), (int)(startPoint.y + 1 + i++ * 20)).entries(inputs).markIsInput());
        }
        class_2588 energyPerTick = new class_2588("techreborn.jei.recipe.running.cost", new Object[]{"E", machineRecipe.getEnergy()});
        LabelWidget costLabel = LabelWidget.create((Point)new Point(startPoint.x + 1, startPoint.y + 1 + i++ * 20), (String)energyPerTick.method_10863());
        widgets.add((Widget)costLabel);
        costLabel.setHasShadows(false);
        costLabel.setDefaultColor(ScreenHelper.isDarkModeEnabled() ? -4473925 : -12566464);
        i = 0;
        for (EntryStack outputs : machineRecipe.getOutputEntries()) {
            widgets.add((Widget)EntryWidget.create((int)(startPoint.x + 61), (int)(startPoint.y + 1 + i++ * 20)).entry(outputs).markIsOutput());
        }
        int heat = machineRecipe.getHeat();
        if (heat > 0) {
            String neededHeat = heat + " " + StringUtils.t((String)"techreborn.jei.recipe.heat");
            LabelWidget heatLabel = LabelWidget.create((Point)new Point(startPoint.x + 61, startPoint.y + 1 + i++ * 20), (String)neededHeat);
            widgets.add((Widget)heatLabel);
            heatLabel.setHasShadows(false);
            heatLabel.setDefaultColor(ScreenHelper.isDarkModeEnabled() ? -4473925 : -12566464);
        }
        return widgets;
    }

    public int getDisplayHeight() {
        if (this.recipeLines == 1) {
            return 37;
        }
        if (this.recipeLines == 3) {
            return 80;
        }
        if (this.recipeLines == 4) {
            return 105;
        }
        return 60;
    }
}

