/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.util.version.VersionParsingException;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.GuiTab;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.RecipeManager;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.api.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.api.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.compat.rei.MachineRecipeCategory;
import techreborn.compat.rei.MachineRecipeDisplay;
import techreborn.compat.rei.fluidgenerator.FluidGeneratorRecipeCategory;
import techreborn.compat.rei.fluidgenerator.FluidGeneratorRecipeDisplay;
import techreborn.compat.rei.fluidreplicator.FluidReplicatorRecipeCategory;
import techreborn.compat.rei.fluidreplicator.FluidReplicatorRecipeDisplay;
import techreborn.compat.rei.rollingmachine.RollingMachineCategory;
import techreborn.compat.rei.rollingmachine.RollingMachineDisplay;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;

public class ReiPlugin
implements REIPluginV0 {
    public static final class_2960 PLUGIN = new class_2960("techreborn", "techreborn_plugin");
    public static final Map<RebornRecipeType<?>, class_1935> iconMap = new HashMap();

    public ReiPlugin() {
        iconMap.put(ModRecipes.ALLOY_SMELTER, TRContent.Machine.ALLOY_SMELTER);
        iconMap.put(ModRecipes.ASSEMBLING_MACHINE, TRContent.Machine.ASSEMBLY_MACHINE);
        iconMap.put(ModRecipes.BLAST_FURNACE, TRContent.Machine.INDUSTRIAL_BLAST_FURNACE);
        iconMap.put(ModRecipes.CENTRIFUGE, TRContent.Machine.INDUSTRIAL_CENTRIFUGE);
        iconMap.put(ModRecipes.CHEMICAL_REACTOR, TRContent.Machine.CHEMICAL_REACTOR);
        iconMap.put(ModRecipes.COMPRESSOR, TRContent.Machine.COMPRESSOR);
        iconMap.put(ModRecipes.DISTILLATION_TOWER, TRContent.Machine.DISTILLATION_TOWER);
        iconMap.put(ModRecipes.EXTRACTOR, TRContent.Machine.EXTRACTOR);
        iconMap.put(ModRecipes.FLUID_REPLICATOR, TRContent.Machine.FLUID_REPLICATOR);
        iconMap.put(ModRecipes.FUSION_REACTOR, TRContent.Machine.FUSION_CONTROL_COMPUTER);
        iconMap.put(ModRecipes.GRINDER, TRContent.Machine.GRINDER);
        iconMap.put(ModRecipes.IMPLOSION_COMPRESSOR, TRContent.Machine.IMPLOSION_COMPRESSOR);
        iconMap.put(ModRecipes.INDUSTRIAL_ELECTROLYZER, TRContent.Machine.INDUSTRIAL_ELECTROLYZER);
        iconMap.put(ModRecipes.INDUSTRIAL_GRINDER, TRContent.Machine.INDUSTRIAL_GRINDER);
        iconMap.put(ModRecipes.INDUSTRIAL_SAWMILL, TRContent.Machine.INDUSTRIAL_SAWMILL);
        iconMap.put(ModRecipes.ROLLING_MACHINE, TRContent.Machine.ROLLING_MACHINE);
        iconMap.put(ModRecipes.SCRAPBOX, (class_1935)TRContent.SCRAP_BOX);
        iconMap.put(ModRecipes.SOLID_CANNING_MACHINE, TRContent.Machine.SOLID_CANNING_MACHINE);
        iconMap.put(ModRecipes.VACUUM_FREEZER, TRContent.Machine.VACUUM_FREEZER);
        iconMap.put(ModRecipes.WIRE_MILL, TRContent.Machine.WIRE_MILL);
    }

    public class_2960 getPluginIdentifier() {
        return PLUGIN;
    }

    public SemanticVersion getMinimumVersion() throws VersionParsingException {
        return SemanticVersion.parse((String)"3.2.5");
    }

    public void registerPluginCategories(RecipeHelper recipeHelper) {
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.ALLOY_SMELTER));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.ASSEMBLING_MACHINE));
        recipeHelper.registerCategory(new MachineRecipeCategory<BlastFurnaceRecipe>(ModRecipes.BLAST_FURNACE));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.CENTRIFUGE, 4));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.CHEMICAL_REACTOR));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.COMPRESSOR, 1));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.DISTILLATION_TOWER, 3));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.EXTRACTOR, 1));
        recipeHelper.registerCategory((RecipeCategory)new FluidReplicatorRecipeCategory(ModRecipes.FLUID_REPLICATOR));
        recipeHelper.registerCategory(new MachineRecipeCategory<FusionReactorRecipe>(ModRecipes.FUSION_REACTOR, 2));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.GRINDER, 1));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.IMPLOSION_COMPRESSOR));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.INDUSTRIAL_ELECTROLYZER, 4));
        recipeHelper.registerCategory(new MachineRecipeCategory<IndustrialGrinderRecipe>(ModRecipes.INDUSTRIAL_GRINDER, 3));
        recipeHelper.registerCategory(new MachineRecipeCategory<IndustrialSawmillRecipe>(ModRecipes.INDUSTRIAL_SAWMILL, 3));
        recipeHelper.registerCategory((RecipeCategory)new RollingMachineCategory(ModRecipes.ROLLING_MACHINE));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.SCRAPBOX));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.SOLID_CANNING_MACHINE));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.VACUUM_FREEZER, 1));
        recipeHelper.registerCategory(new MachineRecipeCategory<RebornRecipe>(ModRecipes.WIRE_MILL, 1));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.THERMAL_GENERATOR));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.GAS_TURBINE));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.DIESEL_GENERATOR));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.SEMI_FLUID_GENERATOR));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.PLASMA_GENERATOR));
    }

    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        RecipeManager.getRecipeTypes((String)"techreborn").forEach(rebornRecipeType -> this.registerMachineRecipe(recipeHelper, (RebornRecipeType)rebornRecipeType));
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.THERMAL, TRContent.Machine.THERMAL_GENERATOR);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.GAS, TRContent.Machine.GAS_TURBINE);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.DIESEL, TRContent.Machine.DIESEL_GENERATOR);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.SEMIFLUID, TRContent.Machine.SEMI_FLUID_GENERATOR);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.PLASMA, TRContent.Machine.PLASMA_GENERATOR);
    }

    public void registerOthers(RecipeHelper recipeHelper) {
        recipeHelper.registerWorkingStations(ModRecipes.ALLOY_SMELTER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.ALLOY_SMELTER), EntryStack.create((class_1935)TRContent.Machine.IRON_ALLOY_FURNACE)});
        recipeHelper.registerWorkingStations(ModRecipes.ASSEMBLING_MACHINE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.ASSEMBLY_MACHINE)});
        recipeHelper.registerWorkingStations(ModRecipes.BLAST_FURNACE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_BLAST_FURNACE)});
        recipeHelper.registerWorkingStations(ModRecipes.CENTRIFUGE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_CENTRIFUGE)});
        recipeHelper.registerWorkingStations(ModRecipes.CHEMICAL_REACTOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.CHEMICAL_REACTOR)});
        recipeHelper.registerWorkingStations(ModRecipes.COMPRESSOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.COMPRESSOR)});
        recipeHelper.registerWorkingStations(ModRecipes.DISTILLATION_TOWER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.DISTILLATION_TOWER)});
        recipeHelper.registerWorkingStations(ModRecipes.EXTRACTOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.EXTRACTOR)});
        recipeHelper.registerWorkingStations(ModRecipes.FLUID_REPLICATOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.FLUID_REPLICATOR)});
        recipeHelper.registerWorkingStations(ModRecipes.FUSION_REACTOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.FUSION_CONTROL_COMPUTER)});
        recipeHelper.registerWorkingStations(ModRecipes.GRINDER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.GRINDER)});
        recipeHelper.registerWorkingStations(ModRecipes.IMPLOSION_COMPRESSOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.IMPLOSION_COMPRESSOR)});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_ELECTROLYZER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_ELECTROLYZER)});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_GRINDER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_GRINDER)});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_SAWMILL.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_SAWMILL)});
        recipeHelper.registerWorkingStations(ModRecipes.ROLLING_MACHINE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.ROLLING_MACHINE)});
        recipeHelper.registerWorkingStations(ModRecipes.SOLID_CANNING_MACHINE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.SOLID_CANNING_MACHINE)});
        recipeHelper.registerWorkingStations(ModRecipes.VACUUM_FREEZER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.VACUUM_FREEZER)});
        recipeHelper.registerWorkingStations(ModRecipes.WIRE_MILL.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.WIRE_MILL)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.THERMAL_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.THERMAL_GENERATOR)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.GAS_TURBINE.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.GAS_TURBINE)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.DIESEL_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.DIESEL_GENERATOR)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.SEMI_FLUID_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.SEMI_FLUID_GENERATOR)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.PLASMA_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.PLASMA_GENERATOR)});
    }

    public void postRegister() {
        for (EntryStack stack : EntryRegistry.getInstance().getStacksList()) {
            ReiPlugin.applyCellEntry(stack);
        }
    }

    public static void applyCellEntry(EntryStack stack) {
        if (stack.getItem() == TRContent.CELL) {
            stack.addSetting(EntryStack.Settings.CHECK_TAGS, (Object)EntryStack.Settings.TRUE);
        }
    }

    private void registerFluidGeneratorDisplays(RecipeHelper recipeHelper, EFluidGenerator generator, TRContent.Machine machine) {
        class_2960 identifier = new class_2960("techreborn", machine.name);
        GeneratorRecipeHelper.getFluidRecipesForGenerator(generator).getRecipes().forEach(recipe -> recipeHelper.registerDisplay((RecipeDisplay)new FluidGeneratorRecipeDisplay((FluidGeneratorRecipe)recipe, identifier)));
    }

    private <R extends RebornRecipe> void registerMachineRecipe(RecipeHelper recipeHelper, RebornRecipeType<R> recipeType) {
        Function<RebornRecipe, RecipeDisplay> recipeDisplay = r -> new MachineRecipeDisplay<RebornRecipe>((RebornRecipe)r);
        if (recipeType == ModRecipes.ROLLING_MACHINE) {
            recipeDisplay = r -> {
                RollingMachineRecipe rollingMachineRecipe = (RollingMachineRecipe)((Object)r);
                return new RollingMachineDisplay(rollingMachineRecipe.getShapedRecipe());
            };
        }
        if (recipeType == ModRecipes.FLUID_REPLICATOR) {
            recipeDisplay = r -> {
                FluidReplicatorRecipe recipe = (FluidReplicatorRecipe)((Object)r);
                return new FluidReplicatorRecipeDisplay(recipe);
            };
        }
        recipeHelper.registerRecipes(recipeType.getName(), recipe -> {
            if (recipe instanceof RebornRecipe) {
                return ((RebornRecipe)recipe).getRebornRecipeType() == recipeType;
            }
            return false;
        }, recipeDisplay);
    }

    public void registerBounds(DisplayHelper displayHelper) {
        BaseBoundsHandler baseBoundsHandler = BaseBoundsHandler.getInstance();
        baseBoundsHandler.registerExclusionZones(GuiBase.class, () -> {
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (currentScreen instanceof GuiBase) {
                IUpgradeable upgradeable;
                GuiBase guiBase = (GuiBase)currentScreen;
                int height = 0;
                if (guiBase.tryAddUpgrades() && guiBase.be instanceof IUpgradeable && (upgradeable = (IUpgradeable)guiBase.be).canBeUpgraded()) {
                    height = 80;
                }
                for (GuiTab slot : guiBase.getTabs()) {
                    if (!slot.enabled()) continue;
                    height += 24;
                }
                if (height > 0) {
                    int width = 20;
                    return Collections.singletonList(new Rectangle(guiBase.getGuiLeft() - width, guiBase.getGuiTop() + 8, width, height));
                }
            }
            return Collections.emptyList();
        });
    }
}

