/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei.fluidreplicator;

import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_2960;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.compat.rei.RebornEntryStack;

public class FluidReplicatorRecipeDisplay
implements RecipeDisplay {
    private final FluidReplicatorRecipe recipe;
    private List<List<EntryStack>> inputs;
    private List<EntryStack> output;
    private FluidInstance fluidInstance;
    private int energy = 0;
    private int time = 0;

    public FluidReplicatorRecipeDisplay(FluidReplicatorRecipe recipe) {
        this.recipe = recipe;
        this.inputs = CollectionUtils.map((List)recipe.getRebornIngredients(), ing -> CollectionUtils.map((List)ing.getPreviewStacks(), RebornEntryStack::create));
        this.fluidInstance = recipe.getFluidInstance();
        this.output = this.fluidInstance == null ? Collections.emptyList() : Collections.singletonList(RebornEntryStack.create(this.fluidInstance.getFluid(), this.fluidInstance.getAmount().getRawValue()));
        this.energy = recipe.getPower();
        this.time = recipe.getTime();
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    public List<List<EntryStack>> getInputEntries() {
        return this.inputs;
    }

    public List<EntryStack> getOutputEntries() {
        return this.output;
    }

    public List<List<EntryStack>> getRequiredEntries() {
        return this.inputs;
    }

    public class_2960 getRecipeCategory() {
        return this.recipe.getRebornRecipeType().getName();
    }
}

