/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tool.industrial;

import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2431;
import net.minecraft.class_2449;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.StringUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergyTier;
import techreborn.config.TechRebornConfig;
import techreborn.items.tool.JackhammerItem;
import techreborn.utils.MessageIDs;
import techreborn.utils.ToolsUtil;

public class IndustrialJackhammerItem
extends JackhammerItem {
    public IndustrialJackhammerItem() {
        super(class_1834.field_8930, TechRebornConfig.industrialJackhammerCharge, EnergyTier.INSANE, TechRebornConfig.industrialJackhammerCost);
    }

    private void switchAOE(class_1799 stack, int cost, boolean isClient, int messageId) {
        ItemUtils.checkActive((class_1799)stack, (int)cost, (boolean)isClient, (int)messageId);
        if (!ItemUtils.isActive((class_1799)stack)) {
            ItemUtils.switchActive((class_1799)stack, (int)cost, (boolean)isClient, (int)messageId);
            stack.method_7948().method_10556("AOE5", false);
            if (isClient) {
                ChatUtils.sendNoSpamMessages((int)messageId, (class_2561)new class_2585(class_124.field_1080 + StringUtils.t((String)"techreborn.message.setTo") + " " + class_124.field_1065 + "3*3"));
            }
        } else if (this.isAOE5(stack)) {
            ItemUtils.switchActive((class_1799)stack, (int)cost, (boolean)isClient, (int)messageId);
            stack.method_7948().method_10556("AOE5", false);
        } else {
            stack.method_7948().method_10556("AOE5", true);
            if (isClient) {
                ChatUtils.sendNoSpamMessages((int)messageId, (class_2561)new class_2585(class_124.field_1080 + StringUtils.t((String)"techreborn.message.setTo") + " " + class_124.field_1065 + "5*5"));
            }
        }
    }

    private boolean shouldBreak(class_1937 worldIn, class_2338 originalPos, class_2338 pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        class_2680 blockState = worldIn.method_8320(pos);
        if (blockState.method_11620() == class_3614.field_15959) {
            return false;
        }
        if (blockState.method_11620().method_15797()) {
            return false;
        }
        if (blockState.method_11614() instanceof class_2431) {
            return false;
        }
        if (blockState.method_11614() instanceof class_2449) {
            return false;
        }
        return class_1802.field_8403.method_7856(blockState);
    }

    private boolean isAOE5(class_1799 stack) {
        return !stack.method_7960() && stack.method_7969() != null && stack.method_7969().method_10577("AOE5");
    }

    @Override
    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 stateIn, class_2338 pos, class_1309 entityLiving) {
        if (!ItemUtils.isActive((class_1799)stack)) {
            return super.method_7879(stack, worldIn, stateIn, pos, entityLiving);
        }
        int radius = this.isAOE5(stack) ? 2 : 1;
        for (class_2338 additionalPos : ToolsUtil.getAOEMiningBlocks(worldIn, pos, entityLiving, radius)) {
            if (!this.shouldBreak(worldIn, pos, additionalPos)) continue;
            ToolsUtil.breakBlock(stack, worldIn, additionalPos, entityLiving, this.cost);
        }
        return super.method_7879(stack, worldIn, stateIn, pos, entityLiving);
    }

    @Override
    public float method_7865(class_1799 stack, class_2680 state) {
        if (state.method_11620() == class_3614.field_15914 && Energy.of((Object)stack).getEnergy() >= (double)this.cost) {
            return 32.0f;
        }
        return 0.5f;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            this.switchAOE(stack, this.cost, world.field_9236, MessageIDs.poweredToolID);
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        return new class_1271(class_1269.field_5811, (Object)stack);
    }

    public void method_7852(class_1937 world, class_1309 entity, class_1799 stack, int i) {
        ItemUtils.checkActive((class_1799)stack, (int)this.cost, (boolean)entity.field_6002.field_9236, (int)MessageIDs.poweredToolID);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        ItemUtils.buildActiveTooltip((class_1799)stack, tooltip);
        if (ItemUtils.isActive((class_1799)stack)) {
            if (this.isAOE5(stack)) {
                tooltip.add(new class_2585("5*5").method_10854(class_124.field_1061));
            } else {
                tooltip.add(new class_2585("3*3").method_10854(class_124.field_1061));
            }
        }
    }
}

