/*
 * Decompiled with CFR 0.152.
 */
package techreborn.multiblocks;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockBlockEntityBase;
import reborncore.common.multiblock.rectangular.RectangularMultiblockControllerBase;
import techreborn.blocks.misc.BlockMachineCasing;

public class MultiBlockCasing
extends RectangularMultiblockControllerBase {
    public boolean hasLava;
    public boolean isStar = false;
    public int height = 0;

    public MultiBlockCasing(class_1937 world) {
        super(world);
    }

    public String getInfo() {
        String value = "Intact";
        try {
            this.isMachineWhole();
        }
        catch (MultiblockValidationException e) {
            e.printStackTrace();
            value = e.getLocalizedMessage();
        }
        return value;
    }

    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        class_2338 maximumCoord = this.getMaximumCoord();
        class_2338 minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.method_10263() - minimumCoord.method_10263() + 1;
        int deltaY = maximumCoord.method_10264() - minimumCoord.method_10264() + 1;
        int deltaZ = maximumCoord.method_10260() - minimumCoord.method_10260() + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the X dimension", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Y dimension", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Z dimension", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the X dimension", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Z dimension", minZ));
        }
        this.height = deltaY;
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        Class<?> myClass = ((Object)((Object)this)).getClass();
        for (int x = minimumCoord.method_10263(); x <= maximumCoord.method_10263(); ++x) {
            for (int y = minimumCoord.method_10264(); y <= maximumCoord.method_10264(); ++y) {
                for (int z = minimumCoord.method_10260(); z <= maximumCoord.method_10260(); ++z) {
                    RectangularMultiblockBlockEntityBase part;
                    class_2586 te = this.worldObj.method_8321(new class_2338(x, y, z));
                    if (te instanceof RectangularMultiblockBlockEntityBase) {
                        part = (RectangularMultiblockBlockEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(String.format("Part @ %d, %d, %d is incompatible with machines of type %s", x, y, z, myClass.getSimpleName()));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.method_10263()) {
                        ++extremes;
                    }
                    if (y == minimumCoord.method_10264()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.method_10260()) {
                        ++extremes;
                    }
                    if (x == maximumCoord.method_10263()) {
                        ++extremes;
                    }
                    if (y == maximumCoord.method_10264()) {
                        ++extremes;
                    }
                    if (z == maximumCoord.method_10260()) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.method_10264()) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.method_10264()) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart part, class_2487 data) {
    }

    protected void onBlockAdded(IMultiblockPart newPart) {
    }

    protected void onBlockRemoved(IMultiblockPart oldPart) {
    }

    protected void onMachineAssembled() {
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 1;
    }

    protected int getMaximumXSize() {
        return 3;
    }

    protected int getMaximumZSize() {
        return 3;
    }

    protected int getMaximumYSize() {
        return 4;
    }

    protected int getMinimumXSize() {
        return 3;
    }

    protected int getMinimumYSize() {
        return 3;
    }

    protected int getMinimumZSize() {
        return 3;
    }

    protected void onAssimilate(MultiblockControllerBase assimilated) {
    }

    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    protected boolean updateServer() {
        return true;
    }

    protected void updateClient() {
    }

    public void write(class_2487 data) {
    }

    public void read(class_2487 data) {
    }

    public void formatDescriptionPacket(class_2487 data) {
    }

    public void decodeDescriptionPacket(class_2487 data) {
    }

    protected void isBlockGoodForInterior(class_1937 world, int x, int y, int z) throws MultiblockValidationException {
        class_2680 state = world.method_8320(new class_2338(x, y, z));
        if (!state.method_11620().equals(class_3614.field_15959)) {
            if (state.method_11620().equals(class_3614.field_15922)) {
                this.hasLava = true;
            } else {
                super.isBlockGoodForInterior(world, x, y, z);
            }
        }
    }

    protected void isBlockGoodForFrame(class_1937 world, int x, int y, int z) throws MultiblockValidationException {
        class_2248 block = world.method_8320(new class_2338(x, y, z)).method_11614();
        if (!(block instanceof BlockMachineCasing)) {
            super.isBlockGoodForFrame(world, x, y, z);
        }
    }
}

