/*
 * Decompiled with CFR 0.152.
 */
package techreborn;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.multiblock.MultiblockRenderer;
import reborncore.common.util.ItemUtils;
import reborncore.mixin.client.AccessorModelPredicateProviderRegistry;
import team.reborn.energy.Energy;
import techreborn.client.render.DynamicBucketBakedModel;
import techreborn.client.render.DynamicCellBakedModel;
import techreborn.client.render.entitys.CableCoverRenderer;
import techreborn.client.render.entitys.StorageUnitRenderer;
import techreborn.client.render.entitys.TurbineRenderer;
import techreborn.events.StackToolTipHandler;
import techreborn.init.ModFluids;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;
import techreborn.items.BatteryItem;
import techreborn.items.DynamicCellItem;
import techreborn.items.FrequencyTransmitterItem;
import techreborn.items.armor.BatpackItem;
import techreborn.items.tool.ChainsawItem;
import techreborn.items.tool.industrial.NanosaberItem;

public class TechRebornClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ModelLoadingRegistry.INSTANCE.registerAppender((manager, out) -> {
            out.accept(new class_1091(new class_2960("techreborn", "cell_base"), "inventory"));
            out.accept(new class_1091(new class_2960("techreborn", "cell_fluid"), "inventory"));
            out.accept(new class_1091(new class_2960("techreborn", "cell_background"), "inventory"));
            out.accept(new class_1091(new class_2960("techreborn", "cell_glass"), "inventory"));
            out.accept(new class_1091(new class_2960("techreborn", "bucket_base"), "inventory"));
            out.accept(new class_1091(new class_2960("techreborn", "bucket_fluid"), "inventory"));
            out.accept(new class_1091(new class_2960("techreborn", "bucket_background"), "inventory"));
        });
        ModelLoadingRegistry.INSTANCE.registerVariantProvider(resourceManager -> (modelIdentifier, modelProviderContext) -> {
            if (modelIdentifier.method_12836().equals("techreborn")) {
                if (modelIdentifier.method_12832().equals("cell")) {
                    if (!RendererAccess.INSTANCE.hasRenderer()) {
                        return class_793.method_3430((String)"{\"parent\":\"minecraft:item/generated\",\"textures\":{\"layer0\":\"techreborn:item/cell_background\"}}");
                    }
                    return new class_1100(){

                        public Collection<class_2960> method_4755() {
                            return Collections.emptyList();
                        }

                        public Collection<class_4730> method_4754(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
                            return Collections.emptyList();
                        }

                        public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
                            return new DynamicCellBakedModel();
                        }
                    };
                }
                class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(new class_2960("techreborn", modelIdentifier.method_12832().split("_bucket")[0]));
                if (modelIdentifier.method_12832().endsWith("_bucket") && fluid != class_3612.field_15906) {
                    if (!RendererAccess.INSTANCE.hasRenderer()) {
                        return class_793.method_3430((String)"{\"parent\":\"minecraft:item/generated\",\"textures\":{\"layer0\":\"minecraft:item/bucket\"}}");
                    }
                    return new class_1100(){

                        public Collection<class_2960> method_4755() {
                            return Collections.emptyList();
                        }

                        public Collection<class_4730> method_4754(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
                            return Collections.emptyList();
                        }

                        public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
                            return new DynamicBucketBakedModel();
                        }
                    };
                }
            }
            return null;
        });
        StackToolTipHandler.setup();
        GuiBase.wrenchStack = new class_1799((class_1935)TRContent.WRENCH);
        GuiBase.fluidCellProvider = DynamicCellItem::getCellWithFluid;
        Arrays.stream(TRContent.Cables.values()).forEach(cable -> BlockRenderLayerMap.INSTANCE.putBlock((class_2248)cable.block, class_1921.method_23581()));
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.Machine.LAMP_INCANDESCENT.block, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.Machine.LAMP_LED.block, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.Machine.ALARM.block, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.RUBBER_SAPLING, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.REINFORCED_GLASS, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.Machine.RESIN_BASIN.block, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.POTTED_RUBBER_SAPLING, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(TRContent.RUBBER_LEAVES, class_1921.method_23579());
        for (ModFluids fluid : ModFluids.values()) {
            BlockRenderLayerMap.INSTANCE.putFluid((class_3611)fluid.getFluid(), class_1921.method_23583());
            BlockRenderLayerMap.INSTANCE.putFluid((class_3611)fluid.getFlowingFluid(), class_1921.method_23583());
        }
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.INDUSTRIAL_GRINDER, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.FUSION_CONTROL_COMPUTER, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.INDUSTRIAL_BLAST_FURNACE, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.VACUUM_FREEZER, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.FLUID_REPLICATOR, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.INDUSTRIAL_SAWMILL, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.DISTILLATION_TOWER, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.IMPLOSION_COMPRESSOR, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.GREENHOUSE_CONTROLLER, MultiblockRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.STORAGE_UNIT, StorageUnitRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.CABLE, CableCoverRenderer::new);
        BlockEntityRendererRegistry.INSTANCE.register(TRBlockEntities.WIND_MILL, TurbineRenderer::new);
        TechRebornClient.registerPredicateProvider(BatpackItem.class, new class_2960("techreborn:empty"), (item, stack, world, entity) -> {
            if (!stack.method_7960() && Energy.of((Object)stack).getEnergy() == 0.0) {
                return 1.0f;
            }
            return 0.0f;
        });
        TechRebornClient.registerPredicateProvider(BatteryItem.class, new class_2960("techreborn:empty"), (item, stack, world, entity) -> {
            if (!stack.method_7960() && Energy.of((Object)stack).getEnergy() == 0.0) {
                return 1.0f;
            }
            return 0.0f;
        });
        TechRebornClient.registerPredicateProvider(FrequencyTransmitterItem.class, new class_2960("techreborn:coords"), (item, stack, world, entity) -> {
            if (!stack.method_7960() && stack.method_7985() && stack.method_7969() != null && stack.method_7969().method_10545("x") && stack.method_7969().method_10545("y") && stack.method_7969().method_10545("z") && stack.method_7969().method_10545("dim")) {
                return 1.0f;
            }
            return 0.0f;
        });
        TechRebornClient.registerPredicateProvider(ChainsawItem.class, new class_2960("techreborn:animated"), (item, stack, world, entity) -> {
            if (!stack.method_7960() && Energy.of((Object)stack).getEnergy() >= (double)item.getCost() && entity != null && entity.method_6047().equals(stack)) {
                return 1.0f;
            }
            return 0.0f;
        });
        TechRebornClient.registerPredicateProvider(NanosaberItem.class, new class_2960("techreborn:active"), (item, stack, world, entity) -> {
            if (ItemUtils.isActive((class_1799)stack)) {
                if (Energy.of((Object)stack).getMaxStored() - Energy.of((Object)stack).getEnergy() >= 0.9 * Energy.of((Object)stack).getMaxStored()) {
                    return 0.5f;
                }
                return 1.0f;
            }
            return 0.0f;
        });
    }

    private static <T extends class_1792> void registerPredicateProvider(Class<T> itemClass, class_2960 identifier, ItemModelPredicateProvider<T> modelPredicateProvider) {
        class_2378.field_11142.method_10220().filter(item -> item.getClass().isAssignableFrom(itemClass)).forEach(item -> AccessorModelPredicateProviderRegistry.callRegister((class_1792)item, (class_2960)identifier, (class_1800)modelPredicateProvider));
    }

    private static interface ItemModelPredicateProvider<T extends class_1792>
    extends class_1800 {
        public float call(T var1, class_1799 var2, @Nullable class_638 var3, @Nullable class_1309 var4);

        default public float call(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity) {
            return this.call(stack.method_7909(), stack, world, entity);
        }
    }
}

