/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.RenderingEntry;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.api.blockentity.IUpgradeable;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.GuiTab;
import reborncore.client.gui.guibuilder.GuiBuilder;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.RecipeManager;
import reborncore.common.fluid.container.ItemFluidInfo;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.recipes.BlastFurnaceRecipe;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;
import techreborn.api.recipe.recipes.FusionReactorRecipe;
import techreborn.api.recipe.recipes.IndustrialGrinderRecipe;
import techreborn.api.recipe.recipes.IndustrialSawmillRecipe;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.compat.rei.MachineRecipeDisplay;
import techreborn.compat.rei.fluidgenerator.FluidGeneratorRecipeCategory;
import techreborn.compat.rei.fluidgenerator.FluidGeneratorRecipeDisplay;
import techreborn.compat.rei.fluidreplicator.FluidReplicatorRecipeCategory;
import techreborn.compat.rei.fluidreplicator.FluidReplicatorRecipeDisplay;
import techreborn.compat.rei.machine.AssemblingMachineCategory;
import techreborn.compat.rei.machine.BlastFurnaceCategory;
import techreborn.compat.rei.machine.DistillationTowerCategory;
import techreborn.compat.rei.machine.ElectrolyzerCategory;
import techreborn.compat.rei.machine.GrinderCategory;
import techreborn.compat.rei.machine.ImplosionCompressorCategory;
import techreborn.compat.rei.machine.IndustrialCentrifugeCategory;
import techreborn.compat.rei.machine.OneInputOneOutputCategory;
import techreborn.compat.rei.machine.SawmillCategory;
import techreborn.compat.rei.machine.TwoInputsCenterOutputCategory;
import techreborn.compat.rei.rollingmachine.RollingMachineCategory;
import techreborn.compat.rei.rollingmachine.RollingMachineDisplay;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;

public class ReiPlugin
implements REIPluginV0 {
    public static final class_2960 PLUGIN = new class_2960("techreborn", "techreborn_plugin");
    public static final Map<RebornRecipeType<?>, class_1935> iconMap = new HashMap();

    public ReiPlugin() {
        iconMap.put(ModRecipes.ALLOY_SMELTER, TRContent.Machine.ALLOY_SMELTER);
        iconMap.put(ModRecipes.ASSEMBLING_MACHINE, TRContent.Machine.ASSEMBLY_MACHINE);
        iconMap.put(ModRecipes.BLAST_FURNACE, TRContent.Machine.INDUSTRIAL_BLAST_FURNACE);
        iconMap.put(ModRecipes.CENTRIFUGE, TRContent.Machine.INDUSTRIAL_CENTRIFUGE);
        iconMap.put(ModRecipes.CHEMICAL_REACTOR, TRContent.Machine.CHEMICAL_REACTOR);
        iconMap.put(ModRecipes.COMPRESSOR, TRContent.Machine.COMPRESSOR);
        iconMap.put(ModRecipes.DISTILLATION_TOWER, TRContent.Machine.DISTILLATION_TOWER);
        iconMap.put(ModRecipes.EXTRACTOR, TRContent.Machine.EXTRACTOR);
        iconMap.put(ModRecipes.FLUID_REPLICATOR, TRContent.Machine.FLUID_REPLICATOR);
        iconMap.put(ModRecipes.FUSION_REACTOR, TRContent.Machine.FUSION_CONTROL_COMPUTER);
        iconMap.put(ModRecipes.GRINDER, TRContent.Machine.GRINDER);
        iconMap.put(ModRecipes.IMPLOSION_COMPRESSOR, TRContent.Machine.IMPLOSION_COMPRESSOR);
        iconMap.put(ModRecipes.INDUSTRIAL_ELECTROLYZER, TRContent.Machine.INDUSTRIAL_ELECTROLYZER);
        iconMap.put(ModRecipes.INDUSTRIAL_GRINDER, TRContent.Machine.INDUSTRIAL_GRINDER);
        iconMap.put(ModRecipes.INDUSTRIAL_SAWMILL, TRContent.Machine.INDUSTRIAL_SAWMILL);
        iconMap.put(ModRecipes.ROLLING_MACHINE, TRContent.Machine.ROLLING_MACHINE);
        iconMap.put(ModRecipes.SCRAPBOX, (class_1935)TRContent.SCRAP_BOX);
        iconMap.put(ModRecipes.SOLID_CANNING_MACHINE, TRContent.Machine.SOLID_CANNING_MACHINE);
        iconMap.put(ModRecipes.VACUUM_FREEZER, TRContent.Machine.VACUUM_FREEZER);
        iconMap.put(ModRecipes.WIRE_MILL, TRContent.Machine.WIRE_MILL);
    }

    public class_2960 getPluginIdentifier() {
        return PLUGIN;
    }

    public void registerPluginCategories(RecipeHelper recipeHelper) {
        recipeHelper.registerCategory(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.ALLOY_SMELTER));
        recipeHelper.registerCategory(new AssemblingMachineCategory<RebornRecipe>(ModRecipes.ASSEMBLING_MACHINE));
        recipeHelper.registerCategory(new BlastFurnaceCategory<BlastFurnaceRecipe>(ModRecipes.BLAST_FURNACE));
        recipeHelper.registerCategory(new IndustrialCentrifugeCategory<RebornRecipe>(ModRecipes.CENTRIFUGE));
        recipeHelper.registerCategory(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.CHEMICAL_REACTOR));
        recipeHelper.registerCategory(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.COMPRESSOR));
        recipeHelper.registerCategory(new DistillationTowerCategory<RebornRecipe>(ModRecipes.DISTILLATION_TOWER));
        recipeHelper.registerCategory(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.EXTRACTOR));
        recipeHelper.registerCategory((RecipeCategory)new FluidReplicatorRecipeCategory(ModRecipes.FLUID_REPLICATOR));
        recipeHelper.registerCategory(new TwoInputsCenterOutputCategory<FusionReactorRecipe>(ModRecipes.FUSION_REACTOR));
        recipeHelper.registerCategory(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.GRINDER));
        recipeHelper.registerCategory(new ImplosionCompressorCategory<RebornRecipe>(ModRecipes.IMPLOSION_COMPRESSOR));
        recipeHelper.registerCategory(new ElectrolyzerCategory<RebornRecipe>(ModRecipes.INDUSTRIAL_ELECTROLYZER));
        recipeHelper.registerCategory(new GrinderCategory<IndustrialGrinderRecipe>(ModRecipes.INDUSTRIAL_GRINDER));
        recipeHelper.registerCategory(new SawmillCategory<IndustrialSawmillRecipe>(ModRecipes.INDUSTRIAL_SAWMILL));
        recipeHelper.registerCategory((RecipeCategory)new RollingMachineCategory(ModRecipes.ROLLING_MACHINE));
        recipeHelper.registerCategory(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.SCRAPBOX));
        recipeHelper.registerCategory(new TwoInputsCenterOutputCategory<RebornRecipe>(ModRecipes.SOLID_CANNING_MACHINE));
        recipeHelper.registerCategory(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.VACUUM_FREEZER));
        recipeHelper.registerCategory(new OneInputOneOutputCategory<RebornRecipe>(ModRecipes.WIRE_MILL));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.THERMAL_GENERATOR));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.GAS_TURBINE));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.DIESEL_GENERATOR));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.SEMI_FLUID_GENERATOR));
        recipeHelper.registerCategory((RecipeCategory)new FluidGeneratorRecipeCategory(TRContent.Machine.PLASMA_GENERATOR));
    }

    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        RecipeManager.getRecipeTypes((String)"techreborn").forEach(rebornRecipeType -> this.registerMachineRecipe(recipeHelper, (RebornRecipeType)rebornRecipeType));
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.THERMAL, TRContent.Machine.THERMAL_GENERATOR);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.GAS, TRContent.Machine.GAS_TURBINE);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.DIESEL, TRContent.Machine.DIESEL_GENERATOR);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.SEMIFLUID, TRContent.Machine.SEMI_FLUID_GENERATOR);
        this.registerFluidGeneratorDisplays(recipeHelper, EFluidGenerator.PLASMA, TRContent.Machine.PLASMA_GENERATOR);
    }

    public void registerOthers(RecipeHelper recipeHelper) {
        recipeHelper.registerWorkingStations(ModRecipes.ALLOY_SMELTER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.ALLOY_SMELTER), EntryStack.create((class_1935)TRContent.Machine.IRON_ALLOY_FURNACE)});
        recipeHelper.registerWorkingStations(ModRecipes.ASSEMBLING_MACHINE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.ASSEMBLY_MACHINE)});
        recipeHelper.registerWorkingStations(ModRecipes.BLAST_FURNACE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_BLAST_FURNACE)});
        recipeHelper.registerWorkingStations(ModRecipes.CENTRIFUGE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_CENTRIFUGE)});
        recipeHelper.registerWorkingStations(ModRecipes.CHEMICAL_REACTOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.CHEMICAL_REACTOR)});
        recipeHelper.registerWorkingStations(ModRecipes.COMPRESSOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.COMPRESSOR)});
        recipeHelper.registerWorkingStations(ModRecipes.DISTILLATION_TOWER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.DISTILLATION_TOWER)});
        recipeHelper.registerWorkingStations(ModRecipes.EXTRACTOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.EXTRACTOR)});
        recipeHelper.registerWorkingStations(ModRecipes.FLUID_REPLICATOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.FLUID_REPLICATOR)});
        recipeHelper.registerWorkingStations(ModRecipes.FUSION_REACTOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.FUSION_CONTROL_COMPUTER)});
        recipeHelper.registerWorkingStations(ModRecipes.GRINDER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.GRINDER)});
        recipeHelper.registerWorkingStations(ModRecipes.IMPLOSION_COMPRESSOR.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.IMPLOSION_COMPRESSOR)});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_ELECTROLYZER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_ELECTROLYZER)});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_GRINDER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_GRINDER)});
        recipeHelper.registerWorkingStations(ModRecipes.INDUSTRIAL_SAWMILL.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.INDUSTRIAL_SAWMILL)});
        recipeHelper.registerWorkingStations(ModRecipes.ROLLING_MACHINE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.ROLLING_MACHINE)});
        recipeHelper.registerWorkingStations(ModRecipes.SOLID_CANNING_MACHINE.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.SOLID_CANNING_MACHINE)});
        recipeHelper.registerWorkingStations(ModRecipes.VACUUM_FREEZER.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.VACUUM_FREEZER)});
        recipeHelper.registerWorkingStations(ModRecipes.WIRE_MILL.getName(), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.WIRE_MILL)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.THERMAL_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.THERMAL_GENERATOR)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.GAS_TURBINE.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.GAS_TURBINE)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.DIESEL_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.DIESEL_GENERATOR)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.SEMI_FLUID_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.SEMI_FLUID_GENERATOR)});
        recipeHelper.registerWorkingStations(new class_2960("techreborn", TRContent.Machine.PLASMA_GENERATOR.name), new EntryStack[]{EntryStack.create((class_1935)TRContent.Machine.PLASMA_GENERATOR)});
        this.registerFluidSupport();
    }

    private void registerFluidSupport() {
        FluidSupportProvider.INSTANCE.registerFluidProvider(new FluidSupportProvider.FluidProvider(){

            @NotNull
            public EntryStack itemToFluid(@NotNull EntryStack itemStack) {
                class_3611 fluid;
                if (itemStack.getItem() instanceof ItemFluidInfo && (fluid = ((ItemFluidInfo)itemStack.getItem()).getFluid(itemStack.getItemStack())) != null) {
                    return EntryStack.create((class_3611)fluid);
                }
                return EntryStack.empty();
            }
        });
    }

    public void postRegister() {
        EntryRegistry.getInstance().getEntryStacks().forEach(ReiPlugin::applyCellEntry);
    }

    public static void applyCellEntry(EntryStack stack) {
        if (stack.getItem() == TRContent.CELL) {
            stack.setting(EntryStack.Settings.CHECK_TAGS, (Object)EntryStack.Settings.TRUE);
        }
    }

    private void registerFluidGeneratorDisplays(RecipeHelper recipeHelper, EFluidGenerator generator, TRContent.Machine machine) {
        class_2960 identifier = new class_2960("techreborn", machine.name);
        GeneratorRecipeHelper.getFluidRecipesForGenerator(generator).getRecipes().forEach(recipe -> recipeHelper.registerDisplay((RecipeDisplay)new FluidGeneratorRecipeDisplay((FluidGeneratorRecipe)recipe, identifier)));
    }

    private <R extends RebornRecipe> void registerMachineRecipe(RecipeHelper recipeHelper, RebornRecipeType<R> recipeType) {
        Function<RebornRecipe, RecipeDisplay> recipeDisplay = r -> new MachineRecipeDisplay<RebornRecipe>((RebornRecipe)r);
        if (recipeType == ModRecipes.ROLLING_MACHINE) {
            recipeDisplay = r -> {
                RollingMachineRecipe rollingMachineRecipe = (RollingMachineRecipe)((Object)r);
                return new RollingMachineDisplay(rollingMachineRecipe.getShapedRecipe());
            };
        }
        if (recipeType == ModRecipes.FLUID_REPLICATOR) {
            recipeDisplay = r -> {
                FluidReplicatorRecipe recipe = (FluidReplicatorRecipe)((Object)r);
                return new FluidReplicatorRecipeDisplay(recipe);
            };
        }
        recipeHelper.registerRecipes(recipeType.getName(), recipe -> {
            if (recipe instanceof RebornRecipe) {
                return ((RebornRecipe)recipe).getRebornRecipeType() == recipeType;
            }
            return false;
        }, recipeDisplay);
    }

    public void registerBounds(DisplayHelper displayHelper) {
        BaseBoundsHandler baseBoundsHandler = BaseBoundsHandler.getInstance();
        baseBoundsHandler.registerExclusionZones(GuiBase.class, () -> {
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (currentScreen instanceof GuiBase) {
                IUpgradeable upgradeable;
                GuiBase guiBase = (GuiBase)currentScreen;
                int height = 0;
                if (guiBase.tryAddUpgrades() && guiBase.be instanceof IUpgradeable && (upgradeable = (IUpgradeable)guiBase.be).canBeUpgraded()) {
                    height = 80;
                }
                for (GuiTab slot : guiBase.getTabs()) {
                    if (!slot.enabled()) continue;
                    height += 24;
                }
                if (height > 0) {
                    int width = 20;
                    return Collections.singletonList(new Rectangle(guiBase.getGuiLeft() - width, guiBase.getGuiTop() + 8, width, height));
                }
            }
            return Collections.emptyList();
        });
    }

    public static Widget createProgressBar(int x, int y, double animationDuration, GuiBuilder.ProgressDirection direction) {
        return Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            class_310.method_1551().method_1531().method_22813(GuiBuilder.defaultTextureSheet);
            helper.method_25302(matrices, x, y, direction.x, direction.y, direction.width, direction.height);
            int j = (int)((double)System.currentTimeMillis() / animationDuration % 1.0 * 16.0);
            if (j < 0) {
                j = 0;
            }
            switch (direction) {
                case RIGHT: {
                    helper.method_25302(matrices, x, y, direction.xActive, direction.yActive, j, 10);
                    break;
                }
                case LEFT: {
                    helper.method_25302(matrices, x + 16 - j, y, direction.xActive + 16 - j, direction.yActive, j, 10);
                    break;
                }
                case UP: {
                    helper.method_25302(matrices, x, y + 16 - j, direction.xActive, direction.yActive + 16 - j, 10, j);
                    break;
                }
                case DOWN: {
                    helper.method_25302(matrices, x, y, direction.xActive, direction.yActive, 10, j);
                }
            }
        });
    }

    public static Widget createEnergyDisplay(Rectangle bounds, double energy, EntryAnimation animation, final Function<Point, Tooltip> tooltipBuilder) {
        return new EnergyEntryWidget(bounds, animation).entry((EntryStack)new RenderingEntry(){

            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            }

            @Nullable
            public Tooltip getTooltip(Point mouse) {
                return (Tooltip)tooltipBuilder.apply(mouse);
            }
        }).notFavoritesInteractable();
    }

    public static Widget createFluidDisplay(Rectangle bounds, EntryStack fluid, EntryAnimation animation) {
        return new FluidEntryWidget(bounds, fluid.getFluid(), animation).entry(fluid);
    }

    private static class EnergyEntryWidget
    extends EntryWidget {
        private EntryAnimation animation;

        protected EnergyEntryWidget(Rectangle rectangle, EntryAnimation animation) {
            super(rectangle.x, rectangle.y);
            this.getBounds().setBounds(rectangle);
            this.animation = animation;
        }

        protected void drawBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.background) {
                int innerDisplayHeight;
                Rectangle bounds = this.getBounds();
                int width = bounds.width;
                int height = bounds.height;
                int innerHeight = height - 2;
                PowerSystem.EnergySystem displayPower = PowerSystem.getDisplayPower();
                class_310.method_1551().method_1531().method_22813(GuiBuilder.defaultTextureSheet);
                this.method_25302(matrices, bounds.x, bounds.y, displayPower.xBar - 15, displayPower.yBar - 1, width, height);
                if (this.animation.animationType != EntryAnimationType.NONE) {
                    innerDisplayHeight = class_3532.method_15386((float)((float)(System.currentTimeMillis() / (this.animation.duration / (long)innerHeight) % (long)innerHeight) / 1.0f));
                    if (this.animation.animationType == EntryAnimationType.DOWNWARDS) {
                        innerDisplayHeight = innerHeight - innerDisplayHeight;
                    }
                } else {
                    innerDisplayHeight = innerHeight;
                }
                this.method_25302(matrices, bounds.x + 1, bounds.y + 1 + innerHeight - innerDisplayHeight, displayPower.xBar, innerHeight + displayPower.yBar - innerDisplayHeight, width - 2, innerDisplayHeight);
            }
        }

        protected void drawCurrentEntry(class_4587 matrices, int mouseX, int mouseY, float delta) {
        }
    }

    public static class EntryAnimation {
        private final EntryAnimationType animationType;
        private final long duration;

        private EntryAnimation(EntryAnimationType animationType, long duration) {
            this.animationType = animationType;
            this.duration = duration;
        }

        public static EntryAnimation upwards(long duration) {
            return new EntryAnimation(EntryAnimationType.UPWARDS, duration);
        }

        public static EntryAnimation downwards(long duration) {
            return new EntryAnimation(EntryAnimationType.DOWNWARDS, duration);
        }

        public static EntryAnimation none() {
            return new EntryAnimation(EntryAnimationType.NONE, 0L);
        }
    }

    private static class FluidEntryWidget
    extends EntryWidget {
        private class_3611 fluid;
        private EntryAnimation animation;

        protected FluidEntryWidget(Rectangle rectangle, class_3611 fluid, EntryAnimation animation) {
            super(rectangle.x, rectangle.y);
            this.getBounds().setBounds(rectangle);
            this.fluid = fluid;
            this.animation = animation;
        }

        protected void drawBackground(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.background) {
                int innerDisplayHeight;
                Rectangle bounds = this.getBounds();
                int width = bounds.width;
                int height = bounds.height;
                int innerHeight = height - 2;
                PowerSystem.EnergySystem displayPower = PowerSystem.getDisplayPower();
                class_310.method_1551().method_1531().method_22813(GuiBuilder.defaultTextureSheet);
                this.method_25302(matrices, bounds.x - 3, bounds.y - 3, 194, 26, width + 6, height + 6);
                this.method_25302(matrices, bounds.x, bounds.y, 194, 82, width, height);
                if (this.animation.animationType != EntryAnimationType.NONE) {
                    innerDisplayHeight = class_3532.method_15386((float)((float)(System.currentTimeMillis() / (this.animation.duration / (long)innerHeight) % (long)innerHeight) / 1.0f));
                    if (this.animation.animationType == EntryAnimationType.DOWNWARDS) {
                        innerDisplayHeight = innerHeight - innerDisplayHeight;
                    }
                } else {
                    innerDisplayHeight = innerHeight;
                }
                this.drawFluid(matrices, this.fluid, innerDisplayHeight, bounds.x + 1, bounds.y + 1, width - 2, innerHeight);
            }
        }

        public void drawFluid(class_4587 matrixStack, class_3611 fluid, int drawHeight, int x, int y, int width, int height) {
            int curHeight;
            class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
            y += height;
            FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
            if (handler == null) {
                return;
            }
            class_1058 sprite = handler.getFluidSprites((class_1920)class_310.method_1551().field_1687, class_2338.field_10980, fluid.method_15785())[0];
            int color = FluidRenderHandlerRegistry.INSTANCE.get(fluid).getFluidColor((class_1920)class_310.method_1551().field_1687, class_2338.field_10980, fluid.method_15785());
            int iconHeight = sprite.method_4595();
            RenderSystem.color3f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
            int iteration = 0;
            for (int offsetHeight = drawHeight; offsetHeight != 0; offsetHeight -= curHeight) {
                curHeight = Math.min(offsetHeight, iconHeight);
                class_332.method_25298((class_4587)matrixStack, (int)x, (int)(y - offsetHeight), (int)0, (int)width, (int)curHeight, (class_1058)sprite);
                if (++iteration <= 50) continue;
                break;
            }
        }

        protected void drawCurrentEntry(class_4587 matrices, int mouseX, int mouseY, float delta) {
        }
    }

    public static enum EntryAnimationType {
        UPWARDS,
        DOWNWARDS,
        NONE;

    }
}

