/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei.fluidreplicator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;

public class FluidReplicatorRecipeDisplay
implements RecipeDisplay {
    private final FluidReplicatorRecipe recipe;
    private final List<List<EntryStack>> inputs;
    private final List<EntryStack> output;
    private final FluidInstance fluidInstance;
    private final int energy;
    private final int time;

    public FluidReplicatorRecipeDisplay(FluidReplicatorRecipe recipe) {
        this.recipe = recipe;
        this.inputs = CollectionUtils.map((List)recipe.getRebornIngredients(), ing -> EntryStack.ofItemStacks((Collection)ing.getPreviewStacks()));
        this.fluidInstance = recipe.getFluidInstance();
        this.output = this.fluidInstance == null ? Collections.emptyList() : Collections.singletonList(EntryStack.create((class_3611)this.fluidInstance.getFluid(), (int)this.fluidInstance.getAmount().getRawValue()));
        this.energy = recipe.getPower();
        this.time = recipe.getTime();
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    public List<List<EntryStack>> getInputEntries() {
        return this.inputs;
    }

    public List<EntryStack> getOutputEntries() {
        return this.output;
    }

    public List<List<EntryStack>> getRequiredEntries() {
        return this.inputs;
    }

    public class_2960 getRecipeCategory() {
        return this.recipe.getRebornRecipeType().getName();
    }

    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(this.recipe).map(RebornRecipe::method_8114);
    }
}

