/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import reborncore.common.crafting.ConditionManager;
import techreborn.world.DataDrivenFeature;
import techreborn.world.WorldGenerator;

public class WorldGenConfigReloader
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.loadConfig(manager), prepareExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenApplyAsync(this::apply, applyExecutor);
    }

    private List<DataDrivenFeature> loadConfig(class_3300 manager) {
        Collection featureResources = manager.method_14488("techreborn/features", s -> s.endsWith(".json"));
        LinkedList<DataDrivenFeature> features = new LinkedList<DataDrivenFeature>();
        for (class_2960 resource : featureResources) {
            DataDrivenFeature identifiableObject = this.parse(DataDrivenFeature::deserialise, resource, manager);
            if (identifiableObject == null) continue;
            features.add(identifiableObject);
        }
        LOGGER.info("Loaded " + features.size() + " features");
        return features;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T parse(BiFunction<class_2960, JsonObject, T> deserialiser, class_2960 resource, class_3300 manager) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(manager.method_14486(resource).method_14482(), StandardCharsets.UTF_8);){
            JsonElement jsonElement = new JsonParser().parse((Reader)inputStreamReader);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (!ConditionManager.shouldLoadRecipe((JsonObject)jsonObject)) {
                T t = null;
                return t;
            }
            class_2960 class_29602 = deserialiser.apply(resource, jsonObject);
            return (T)class_29602;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.error("Failed to parse " + resource.toString());
            LOGGER.error((Object)e);
            return null;
        }
    }

    private Void apply(List<DataDrivenFeature> features) {
        WorldGenerator.worldGenObseravable.pushB(features);
        return null;
    }

    public class_2960 getFabricId() {
        return new class_2960("techreborn", "worldgenerator");
    }

    public static List<DataDrivenFeature> getActiveFeatures() {
        return (List)WorldGenerator.worldGenObseravable.getB();
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singletonList(ResourceReloadListenerKeys.TAGS);
    }
}

