/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3264;
import net.minecraft.class_3297;
import net.minecraft.class_4643;
import net.minecraft.class_4648;
import net.minecraft.class_5458;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.common.util.BiObseravable;
import reborncore.mixin.common.AccessorFoliagePlacerType;
import techreborn.world.DataDrivenFeature;
import techreborn.world.RubberTreeDecorator;
import techreborn.world.RubberTreeFeature;
import techreborn.world.WorldGenConfigReloader;

public class WorldGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static class_3031<class_4643> RUBBER_TREE_FEATURE;
    public static RubberTreeDecorator RUBBER_TREE_DECORATOR;
    public static class_4648<RubberTreeFeature.FoliagePlacer> RUBBER_TREE_FOLIAGE_PLACER_TYPE;
    public static BiObseravable<class_2385<class_2975<?, ?>>, List<DataDrivenFeature>> worldGenObseravable;
    private static final IntArrayList modifiedRegistries;

    public static void initWorldGen() {
        WorldGenerator.registerTreeDecorators();
        worldGenObseravable.listen(WorldGenerator::applyToActiveRegistry);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new WorldGenConfigReloader());
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> worldGenObseravable.pushA((Object)registryManager.method_30530(class_5458.field_25929.method_30517())));
        BiomeModifications.create((class_2960)new class_2960("techreborn", "features")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, biomeModificationContext) -> {
            for (DataDrivenFeature feature : (List)worldGenObseravable.getB()) {
                if (!feature.getBiomeSelector().test((BiomeSelectionContext)biomeSelectionContext)) continue;
                biomeModificationContext.getGenerationSettings().addFeature(feature.getGenerationStep(), feature.getRegistryKey());
            }
        });
    }

    public static void applyToActiveRegistry(class_2385<class_2975<?, ?>> registry, List<DataDrivenFeature> features) {
        int hashCode = registry.hashCode();
        if (modifiedRegistries.contains(hashCode)) {
            LOGGER.debug("Already modified world gen on this registry");
            return;
        }
        modifiedRegistries.add(registry.hashCode());
        LOGGER.debug("Applying " + features.size() + " features to active registry: " + registry);
        for (DataDrivenFeature feature : features) {
            registry.method_10272(feature.getRegistryKey(), feature.getConfiguredFeature(), Lifecycle.stable());
        }
    }

    private static void registerTreeDecorators() {
        RUBBER_TREE_FEATURE = (class_3031)class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)new class_2960("techreborn:rubber_tree"), (Object)((Object)new RubberTreeFeature((Codec<class_4643>)class_4643.field_24921)));
        RUBBER_TREE_DECORATOR = (RubberTreeDecorator)((Object)class_2378.method_10230((class_2378)class_2378.field_11148, (class_2960)new class_2960("techreborn:rubber_tree"), (Object)((Object)new RubberTreeDecorator((Codec<class_3297>)class_3297.field_24980))));
        RUBBER_TREE_FOLIAGE_PLACER_TYPE = AccessorFoliagePlacerType.register((String)"techreborn:rubber_tree", RubberTreeFeature.FoliagePlacer.CODEC);
    }

    static {
        worldGenObseravable = new BiObseravable();
        modifiedRegistries = new IntArrayList();
    }
}

