/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.util.OreDrop;
import reborncore.common.util.OreDropSet;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.items.ItemDusts;
import techreborn.items.ItemGems;

public class BlockOre
extends Block {
    public static final String[] types = new String[]{"Galena", "Iridium", "Ruby", "Sapphire", "Bauxite", "Pyrite", "Cinnabar", "Sphalerite", "Tungston", "Sheldonite", "Peridot", "Sodalite", "Tetrahedrite", "Cassiterite", "Lead", "Silver"};
    private IIcon[] textures;

    public static ItemStack getOreByName(String name, int count) {
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(name)) continue;
            index = i;
            break;
        }
        return new ItemStack(ModBlocks.ore, count, index);
    }

    public static ItemStack getOreByName(String name) {
        return BlockOre.getOreByName(name, 1);
    }

    public BlockOre(Material material) {
        super(material);
        this.func_149663_c("techreborn.ore");
        this.func_149647_a(TechRebornCreativeTabMisc.instance);
        this.func_149711_c(2.0f);
        ModBlocks.blocksToCut.add(this);
        this.setHarvestLevel("pickaxe", 2);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (metadata == 2) {
            OreDrop ruby = new OreDrop(ItemGems.getGemByName("ruby"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop redGarnet = new OreDrop(ItemGems.getGemByName("redGarnet"), Double.valueOf(0.02));
            OreDropSet set = new OreDropSet(new OreDrop[]{ruby, redGarnet});
            return set.drop(fortune, world.field_73012_v);
        }
        if (metadata == 3) {
            OreDrop sapphire = new OreDrop(ItemGems.getGemByName("sapphire"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop peridot = new OreDrop(ItemGems.getGemByName("peridot"), Double.valueOf(0.03));
            OreDropSet set = new OreDropSet(new OreDrop[]{sapphire, peridot});
            return set.drop(fortune, world.field_73012_v);
        }
        if (metadata == 5) {
            OreDrop pyriteDust = new OreDrop(ItemDusts.getDustByName("pyrite"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDropSet set = new OreDropSet(new OreDrop[]{pyriteDust});
            return set.drop(fortune, world.field_73012_v);
        }
        if (metadata == 11) {
            OreDrop sodalite = new OreDrop(ItemDusts.getDustByName("sodalite", 6), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop aluminum = new OreDrop(ItemDusts.getDustByName("aluminum"), Double.valueOf(0.5));
            OreDropSet set = new OreDropSet(new OreDrop[]{sodalite, aluminum});
            return set.drop(fortune, world.field_73012_v);
        }
        if (metadata == 6) {
            OreDrop cinnabar = new OreDrop(ItemDusts.getDustByName("cinnabar"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop redstone = new OreDrop(new ItemStack(Items.field_151137_ax), Double.valueOf(0.25));
            OreDropSet set = new OreDropSet(new OreDrop[]{cinnabar, redstone});
            return set.drop(fortune, world.field_73012_v);
        }
        if (metadata == 7) {
            OreDrop sphalerite = new OreDrop(ItemDusts.getDustByName("sphalerite"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop yellowGarnet = new OreDrop(ItemGems.getGemByName("yellowGarnet"), Double.valueOf(0.125));
            OreDropSet set = new OreDropSet(new OreDrop[]{sphalerite, yellowGarnet});
            return set.drop(fortune, world.field_73012_v);
        }
        ArrayList<ItemStack> block = new ArrayList<ItemStack>();
        block.add(new ItemStack(Item.func_150898_a((Block)this), 1, metadata));
        return block;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public int func_149692_a(int metaData) {
        if (metaData == 2) {
            return 0;
        }
        if (metaData == 3) {
            return 1;
        }
        if (metaData == 5) {
            return 60;
        }
        return metaData;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("techreborn:ore/ore" + types[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        metaData = MathHelper.func_76125_a((int)metaData, (int)0, (int)(types.length - 1));
        if (ForgeDirection.getOrientation((int)side) == ForgeDirection.UP || ForgeDirection.getOrientation((int)side) == ForgeDirection.DOWN) {
            return this.textures[metaData];
        }
        return this.textures[metaData];
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack(ModBlocks.ore, 1, world.func_72805_g(x, y, z));
    }
}

