/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import reborncore.common.util.ItemUtils;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.client.gui.GuiFusionReactor;

public class FustionReacorRecipeHandler
extends TemplateRecipeHandler {
    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)4, (int)4, (int)166, (int)78);
        GuiDraw.drawTooltipBox((int)10, (int)80, (int)145, (int)50);
        GuiDraw.drawString((String)"Info:", (int)14, (int)84, (int)-1);
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (recipe instanceof CachedReactorRecipe) {
            CachedReactorRecipe genericRecipe = (CachedReactorRecipe)recipe;
            float scale = 0.9f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
            symbols.setGroupingSeparator('.');
            formatter.setDecimalFormatSymbols(symbols);
            GuiDraw.drawString((String)("Start: " + formatter.format(genericRecipe.recipe.getStartEU()) + "EU"), (int)16, (int)105, (int)-1);
            GuiDraw.drawString((String)("EU/t: " + genericRecipe.recipe.getEuTick()), (int)16, (int)115, (int)-1);
            GuiDraw.drawString((String)("Ticks to process: " + genericRecipe.recipe.getTickTime()), (int)14, (int)125, (int)-1);
            GuiDraw.drawString((String)("Time to process: " + genericRecipe.recipe.getTickTime() / 20 + " seconds"), (int)14, (int)135, (int)-1);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeName())) {
            for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
                this.addCached(recipeType);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
            if (!ItemUtils.isItemEqual((ItemStack)recipeType.getOutput(), (ItemStack)result, (boolean)true, (boolean)false, (boolean)true)) continue;
            this.addCached(recipeType);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
            if (ItemUtils.isItemEqual((ItemStack)ingredient, (ItemStack)recipeType.getTopInput(), (boolean)true, (boolean)false, (boolean)true)) {
                this.addCached(recipeType);
            }
            if (!ItemUtils.isItemEqual((ItemStack)ingredient, (ItemStack)recipeType.getBottomInput(), (boolean)true, (boolean)false, (boolean)true)) continue;
            this.addCached(recipeType);
        }
    }

    private void addCached(FusionReactorRecipe recipie) {
        this.arecipes.add(new CachedReactorRecipe(recipie));
    }

    public void addPositionedStacks(List<PositionedStack> input, List<PositionedStack> outputs, FusionReactorRecipe recipeType) {
        int offset = 4;
        PositionedStack pStack = new PositionedStack((Object)ItemUtils.getStackWithAllOre((ItemStack)recipeType.getTopInput()), 88 - offset, 17 - offset, false);
        input.add(pStack);
        if (recipeType.getBottomInput() != null) {
            PositionedStack pStack2 = new PositionedStack((Object)ItemUtils.getStackWithAllOre((ItemStack)recipeType.getBottomInput()), 88 - offset, 53 - offset, false);
            input.add(pStack2);
        }
        PositionedStack pStack3 = new PositionedStack((Object)recipeType.getOutput(), 148 - offset, 35 - offset, false);
        outputs.add(pStack3);
    }

    public String getRecipeName() {
        return "Fustion Reactor";
    }

    public String getGuiTexture() {
        return "techreborn:textures/gui/fusion_reactor.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFusionReactor.class;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(82, 23, 52, 18), this.getRecipeName(), new Object[0]));
    }

    public class CachedReactorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> input;
        private List<PositionedStack> outputs;
        public Point focus;
        public FusionReactorRecipe recipe;

        public CachedReactorRecipe(FusionReactorRecipe recipe) {
            super((TemplateRecipeHandler)FustionReacorRecipeHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.recipe = recipe;
            FustionReacorRecipeHandler.this.addPositionedStacks(this.input, this.outputs, recipe);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(FustionReacorRecipeHandler.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

